/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.clients;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.common.clients.WavefrontClient;
import com.wavefront.sdk.common.clients.WavefrontMultiClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WavefrontClientFactory {
    private static final Logger log = Logger.getLogger(WavefrontClientFactory.class.getCanonicalName());
    private static final String PROXY_SCHEME = "proxy";
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private final List<WavefrontSender> clients = new ArrayList<WavefrontSender>();

    public WavefrontClientFactory addClient(WavefrontSender sender) {
        if (!this.existingClient(sender.getClientId())) {
            this.clients.add(sender);
        }
        return this;
    }

    public WavefrontClientFactory addClient(String url) {
        return this.addClient(url, null, null, null, null);
    }

    public WavefrontClientFactory addClient(String url, @Nullable Integer batchSize, @Nullable Integer maxQueueSize, @Nullable Integer flushIntervalSeconds, @Nullable Integer messageSizeInBytes) {
        return this.addClient(url, batchSize, maxQueueSize, flushIntervalSeconds, messageSizeInBytes, true);
    }

    public WavefrontClientFactory addClient(String url, @Nullable Integer batchSize, @Nullable Integer maxQueueSize, @Nullable Integer flushIntervalSeconds, @Nullable Integer messageSizeInBytes, boolean includeSdkMetrics) {
        return this.addClient(url, batchSize, maxQueueSize, flushIntervalSeconds, messageSizeInBytes, includeSdkMetrics, null);
    }

    public WavefrontClientFactory addClient(String url, @Nullable Integer batchSize, @Nullable Integer maxQueueSize, @Nullable Integer flushIntervalSeconds, @Nullable Integer messageSizeInBytes, boolean includeSdkMetrics, @Nullable Map<String, String> sdkMetricTags) {
        return this.addClient(url, batchSize, maxQueueSize, flushIntervalSeconds, TimeUnit.SECONDS, messageSizeInBytes, includeSdkMetrics, sdkMetricTags);
    }

    public WavefrontClientFactory addClient(String url, @Nullable Integer batchSize, @Nullable Integer maxQueueSize, @Nullable Integer flushInterval, @Nullable TimeUnit flushIntervalTimeUnit, @Nullable Integer messageSizeInBytes, boolean includeSdkMetrics, @Nullable Map<String, String> sdkMetricTags) {
        Pair<String, String> serverToken = WavefrontClientFactory.parseEndpoint(url);
        if (this.existingClient((String)serverToken._1)) {
            throw new UnsupportedOperationException("client with id " + url + " already exists.");
        }
        WavefrontClient.Builder builder = new WavefrontClient.Builder((String)serverToken._1, (String)serverToken._2);
        if (batchSize != null) {
            builder.batchSize(batchSize);
        }
        if (maxQueueSize != null) {
            builder.maxQueueSize(maxQueueSize);
        }
        if (flushInterval != null && flushIntervalTimeUnit != null) {
            builder.flushInterval(flushInterval, flushIntervalTimeUnit);
        }
        if (messageSizeInBytes != null) {
            builder.messageSizeBytes(messageSizeInBytes);
        }
        builder.includeSdkMetrics(includeSdkMetrics);
        if (includeSdkMetrics && sdkMetricTags != null && sdkMetricTags.size() > 0) {
            builder.sdkMetricsTags(sdkMetricTags);
        }
        this.clients.add(builder.build());
        return this;
    }

    public WavefrontSender getClient() {
        if (this.clients.size() == 0) {
            log.log(Level.WARNING, "Call to getClient without any endpoints having been specified");
            return null;
        }
        if (this.clients.size() == 1) {
            return this.clients.get(0);
        }
        WavefrontMultiClient.Builder builder = new WavefrontMultiClient.Builder();
        this.clients.forEach(builder::withWavefrontSender);
        return builder.build();
    }

    private boolean existingClient(String server) {
        return this.clients.stream().anyMatch(c -> c.getClientId().equals(server));
    }

    @VisibleForTesting
    static Pair<String, String> parseEndpoint(String endpoint) {
        String scheme;
        URI uri = URI.create(endpoint);
        String string = scheme = PROXY_SCHEME.equals(uri.getScheme()) ? HTTP_SCHEME : uri.getScheme();
        if (!scheme.equals(HTTP_SCHEME) && !scheme.equals(HTTPS_SCHEME)) {
            throw new IllegalArgumentException("Unknown scheme (" + scheme + ") specified while attempting to build a client " + endpoint);
        }
        String token = uri.getUserInfo();
        if (token != null && scheme.equals(HTTP_SCHEME)) {
            log.log(Level.WARNING, "Attempting to send a token over clear-text, dropping token.");
            token = null;
        }
        StringBuilder host = new StringBuilder(scheme).append("://").append(uri.getHost());
        if (uri.getPort() > 0) {
            host.append(":").append(uri.getPort());
        }
        return Pair.of(host.toString(), token);
    }
}

