/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.jersey;

import com.wavefront.internal.reporter.SdkReporter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.jaxrs.Constants;
import com.wavefront.sdk.jersey.MetricNameUtils;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import jersey.repackaged.com.google.common.base.Preconditions;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.internal.routing.RoutingContext;

public class WavefrontJerseyFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger logger = Logger.getLogger(WavefrontJerseyFilter.class.getName());
    private final SdkReporter wfJerseyReporter;
    private final ApplicationTags applicationTags;
    private final ThreadLocal<StatsContext> statsContextThreadLocal = new ThreadLocal();
    private final ConcurrentMap<MetricName, AtomicInteger> gauges = new ConcurrentHashMap<MetricName, AtomicInteger>();
    private final Set<String> headerTags;
    @Nullable
    private final Tracer tracer;

    private WavefrontJerseyFilter(SdkReporter wfJerseyReporter, ApplicationTags applicationTags, @Nullable Tracer tracer, Set<String> headerTags) {
        Preconditions.checkNotNull((Object)wfJerseyReporter, (Object)"Invalid JerseyReporter");
        Preconditions.checkNotNull((Object)applicationTags, (Object)"Invalid ApplicationTags");
        this.wfJerseyReporter = wfJerseyReporter;
        this.applicationTags = applicationTags;
        this.tracer = tracer;
        this.headerTags = headerTags;
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        try {
            this.processRequest(containerRequestContext);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception filtering jersey containerRequest", t);
        }
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) {
        try {
            this.processResponse(containerRequestContext, containerResponseContext);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception filtering jersey containerResponse", t);
        }
    }

    private void processRequest(ContainerRequestContext containerRequestContext) {
        if (containerRequestContext instanceof ContainerRequest) {
            ContainerRequest request = (ContainerRequest)containerRequestContext;
            long startTime = System.currentTimeMillis();
            long startTimeCpuNanos = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime();
            Optional<Pair<String, String>> pairOptional = MetricNameUtils.metricNameAndPath(request);
            if (!pairOptional.isPresent()) {
                this.statsContextThreadLocal.set(new StatsContext(startTime, startTimeCpuNanos, null, null));
                return;
            }
            String requestMetricKey = "request." + (String)pairOptional.get()._1;
            String finalMatchingPath = (String)pairOptional.get()._2;
            ExtendedUriInfo uriInfo = request.getUriInfo();
            Pair<String, String> pair = this.getClassAndMethodName(uriInfo);
            String finalClassName = (String)pair._1;
            String finalMethodName = (String)pair._2;
            if (this.tracer != null) {
                Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(finalClassName.substring(finalClassName.lastIndexOf(46) + 1) + "." + finalMethodName).withTag(Tags.SPAN_KIND.getKey(), "server").withTag("jersey.resource.class", finalClassName).withTag("jersey.path", finalMatchingPath);
                SpanContext parentSpanContext = this.parentSpanContext(containerRequestContext);
                if (parentSpanContext != null) {
                    spanBuilder.asChildOf(parentSpanContext);
                }
                this.handleHeaderTags(containerRequestContext, spanBuilder);
                Scope scope = spanBuilder.startActive(false);
                this.decorateRequest(containerRequestContext, scope.span());
                containerRequestContext.setProperty(Constants.PROPERTY_NAME, (Object)scope);
            }
            AtomicInteger apiInflight = this.getGaugeValue(new MetricName(requestMetricKey + ".inflight", this.getCompleteTagsMap(finalClassName, finalMethodName)));
            apiInflight.incrementAndGet();
            AtomicInteger totalInflight = this.getGaugeValue(new MetricName("total_requests.inflight", (Map)new HashMap<String, String>(){
                {
                    this.put("cluster", WavefrontJerseyFilter.this.applicationTags.getCluster() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getCluster());
                    this.put("service", WavefrontJerseyFilter.this.applicationTags.getService());
                    this.put("shard", WavefrontJerseyFilter.this.applicationTags.getShard() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getShard());
                }
            }));
            totalInflight.incrementAndGet();
            this.statsContextThreadLocal.set(new StatsContext(startTime, startTimeCpuNanos, apiInflight, totalInflight));
        }
    }

    private void handleHeaderTags(ContainerRequestContext containerRequestContext, Tracer.SpanBuilder spanBuilder) {
        if (this.headerTags.size() == 0) {
            return;
        }
        MultivaluedMap requestHeaders = containerRequestContext.getHeaders();
        for (String headerName : this.headerTags) {
            if (!requestHeaders.containsKey((Object)headerName)) continue;
            for (String requestHeaderValue : (List)requestHeaders.get((Object)headerName)) {
                spanBuilder.withTag(headerName, requestHeaderValue);
            }
        }
    }

    private void processResponse(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) {
        if (this.tracer != null) {
            try {
                Scope scope = (Scope)containerRequestContext.getProperty(Constants.PROPERTY_NAME);
                if (scope != null) {
                    this.decorateResponse(containerResponseContext, scope.span());
                    scope.close();
                    scope.span().finish();
                }
            }
            catch (ClassCastException scope) {
                // empty catch block
            }
        }
        if (containerRequestContext instanceof ContainerRequest) {
            ContainerRequest request = (ContainerRequest)containerRequestContext;
            ExtendedUriInfo uriInfo = request.getUriInfo();
            Pair<String, String> pair = this.getClassAndMethodName(uriInfo);
            final String finalClassName = (String)pair._1;
            final String finalMethodName = (String)pair._2;
            Optional<Pair<String, String>> apiPathOptionalPair = MetricNameUtils.metricNameAndPath(request);
            if (!apiPathOptionalPair.isPresent()) {
                return;
            }
            if (this.tracer != null) {
                String matchingPath = (String)apiPathOptionalPair.get()._2;
                containerResponseContext.getHeaders().add((Object)"X-WF-SPAN-NAME", (Object)matchingPath);
            }
            String responseMetricKeyWithoutStatus = "response." + (String)apiPathOptionalPair.get()._1;
            String responseMetricKey = responseMetricKeyWithoutStatus + "." + containerResponseContext.getStatus();
            Map<String, String> completeTagsMap = this.getCompleteTagsMap(finalClassName, finalMethodName);
            HashMap<String, String> aggregatedPerShardMap = new HashMap<String, String>(){
                {
                    this.put("cluster", WavefrontJerseyFilter.this.applicationTags.getCluster() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getCluster());
                    this.put("service", WavefrontJerseyFilter.this.applicationTags.getService());
                    this.put("shard", WavefrontJerseyFilter.this.applicationTags.getShard() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getShard());
                    this.put("jersey.resource.class", finalClassName);
                    this.put("jersey.resource.method", finalMethodName);
                    this.put("source", "wavefront-provided");
                }
            };
            HashMap<String, String> overallAggregatedPerSourceMap = new HashMap<String, String>(){
                {
                    this.put("cluster", WavefrontJerseyFilter.this.applicationTags.getCluster() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getCluster());
                    this.put("service", WavefrontJerseyFilter.this.applicationTags.getService());
                    this.put("shard", WavefrontJerseyFilter.this.applicationTags.getShard() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getShard());
                }
            };
            HashMap<String, String> overallAggregatedPerShardMap = new HashMap<String, String>(){
                {
                    this.put("cluster", WavefrontJerseyFilter.this.applicationTags.getCluster() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getCluster());
                    this.put("service", WavefrontJerseyFilter.this.applicationTags.getService());
                    this.put("shard", WavefrontJerseyFilter.this.applicationTags.getShard() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getShard());
                    this.put("source", "wavefront-provided");
                }
            };
            HashMap<String, String> aggregatedPerServiceMap = new HashMap<String, String>(){
                {
                    this.put("cluster", WavefrontJerseyFilter.this.applicationTags.getCluster() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getCluster());
                    this.put("service", WavefrontJerseyFilter.this.applicationTags.getService());
                    this.put("jersey.resource.class", finalClassName);
                    this.put("jersey.resource.method", finalMethodName);
                    this.put("source", "wavefront-provided");
                }
            };
            HashMap<String, String> overallAggregatedPerServiceMap = new HashMap<String, String>(){
                {
                    this.put("cluster", WavefrontJerseyFilter.this.applicationTags.getCluster() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getCluster());
                    this.put("service", WavefrontJerseyFilter.this.applicationTags.getService());
                    this.put("source", "wavefront-provided");
                }
            };
            HashMap<String, String> aggregatedPerClusterMap = new HashMap<String, String>(){
                {
                    this.put("cluster", WavefrontJerseyFilter.this.applicationTags.getCluster() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getCluster());
                    this.put("jersey.resource.class", finalClassName);
                    this.put("jersey.resource.method", finalMethodName);
                    this.put("source", "wavefront-provided");
                }
            };
            HashMap<String, String> overallAggregatedPerClusterMap = new HashMap<String, String>(){
                {
                    this.put("cluster", WavefrontJerseyFilter.this.applicationTags.getCluster() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getCluster());
                    this.put("source", "wavefront-provided");
                }
            };
            HashMap<String, String> aggregatedPerApplicationMap = new HashMap<String, String>(){
                {
                    this.put("jersey.resource.class", finalClassName);
                    this.put("jersey.resource.method", finalMethodName);
                    this.put("source", "wavefront-provided");
                }
            };
            HashMap<String, String> overallAggregatedPerApplicationMap = new HashMap<String, String>(){
                {
                    this.put("source", "wavefront-provided");
                }
            };
            this.wfJerseyReporter.incrementCounter(new MetricName(responseMetricKey + ".cumulative", completeTagsMap));
            if (this.applicationTags.getShard() != null) {
                this.wfJerseyReporter.incrementDeltaCounter(new MetricName(responseMetricKey + ".aggregated_per_shard", (Map)aggregatedPerShardMap));
            }
            this.wfJerseyReporter.incrementDeltaCounter(new MetricName(responseMetricKey + ".aggregated_per_service", (Map)aggregatedPerServiceMap));
            if (this.applicationTags.getCluster() != null) {
                this.wfJerseyReporter.incrementDeltaCounter(new MetricName(responseMetricKey + ".aggregated_per_cluster", (Map)aggregatedPerClusterMap));
            }
            this.wfJerseyReporter.incrementDeltaCounter(new MetricName(responseMetricKey + ".aggregated_per_application", (Map)aggregatedPerApplicationMap));
            if (this.isErrorStatusCode(containerResponseContext)) {
                this.wfJerseyReporter.incrementCounter(new MetricName(responseMetricKeyWithoutStatus + ".errors", completeTagsMap));
                this.wfJerseyReporter.incrementCounter(new MetricName("response.errors", completeTagsMap));
                this.wfJerseyReporter.incrementCounter(new MetricName("response.errors.aggregated_per_source", (Map)overallAggregatedPerSourceMap));
                if (this.applicationTags.getShard() != null) {
                    this.wfJerseyReporter.incrementDeltaCounter(new MetricName("response.errors.aggregated_per_shard", (Map)overallAggregatedPerShardMap));
                }
                this.wfJerseyReporter.incrementDeltaCounter(new MetricName("response.errors.aggregated_per_service", (Map)overallAggregatedPerServiceMap));
                if (this.applicationTags.getCluster() != null) {
                    this.wfJerseyReporter.incrementDeltaCounter(new MetricName("response.errors.aggregated_per_cluster", (Map)overallAggregatedPerClusterMap));
                }
                this.wfJerseyReporter.incrementDeltaCounter(new MetricName("response.errors.aggregated_per_application", (Map)overallAggregatedPerApplicationMap));
            }
            this.wfJerseyReporter.incrementCounter(new MetricName("response.completed.aggregated_per_source", (Map)overallAggregatedPerSourceMap));
            if (this.applicationTags.getShard() != null) {
                this.wfJerseyReporter.incrementDeltaCounter(new MetricName("response.completed.aggregated_per_shard", (Map)overallAggregatedPerShardMap));
            }
            this.wfJerseyReporter.incrementDeltaCounter(new MetricName("response.completed.aggregated_per_service", (Map)overallAggregatedPerServiceMap));
            if (this.applicationTags.getCluster() != null) {
                this.wfJerseyReporter.incrementDeltaCounter(new MetricName("response.completed.aggregated_per_cluster", (Map)overallAggregatedPerClusterMap));
            }
            this.wfJerseyReporter.incrementDeltaCounter(new MetricName("response.completed.aggregated_per_application", (Map)overallAggregatedPerApplicationMap));
            StatsContext statsContext = this.statsContextThreadLocal.get();
            if (statsContext != null) {
                if (statsContext.getApiInflight() != null) {
                    statsContext.getApiInflight().decrementAndGet();
                }
                if (statsContext.getTotalInflight() != null) {
                    statsContext.getTotalInflight().decrementAndGet();
                }
                long cpuNanos = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() - statsContext.getStartCpuNanos();
                this.wfJerseyReporter.updateHistogram(new MetricName(responseMetricKey + ".cpu_ns", completeTagsMap), cpuNanos);
                long apiLatency = System.currentTimeMillis() - statsContext.getStartTime();
                this.wfJerseyReporter.updateHistogram(new MetricName(responseMetricKey + ".latency", completeTagsMap), apiLatency);
                this.wfJerseyReporter.incrementCounter(new MetricName(responseMetricKey + ".total_time", completeTagsMap), apiLatency);
            }
        }
    }

    private Pair<String, String> getClassAndMethodName(ExtendedUriInfo uriInfo) {
        String className = "unknown";
        String methodName = "unknown";
        if (uriInfo != null) {
            Method method;
            Class clazz = ((RoutingContext)uriInfo).getResourceClass();
            if (clazz != null) {
                className = clazz.getCanonicalName();
            }
            if ((method = ((RoutingContext)uriInfo).getResourceMethod()) != null) {
                methodName = method.getName();
            }
        }
        return Pair.of((Object)className, (Object)methodName);
    }

    private AtomicInteger getGaugeValue(MetricName metricName) {
        return this.gauges.computeIfAbsent(metricName, key -> {
            AtomicInteger toReturn = new AtomicInteger();
            this.wfJerseyReporter.registerGauge(key, toReturn);
            return toReturn;
        });
    }

    private Map<String, String> getCompleteTagsMap(final String finalClassName, final String finalMethodName) {
        return new HashMap<String, String>(){
            {
                this.put("cluster", WavefrontJerseyFilter.this.applicationTags.getCluster() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getCluster());
                this.put("service", WavefrontJerseyFilter.this.applicationTags.getService());
                this.put("shard", WavefrontJerseyFilter.this.applicationTags.getShard() == null ? "none" : WavefrontJerseyFilter.this.applicationTags.getShard());
                this.put("jersey.resource.class", finalClassName);
                this.put("jersey.resource.method", finalMethodName);
            }
        };
    }

    private SpanContext parentSpanContext(ContainerRequestContext requestContext) {
        Span activeSpan = this.tracer.activeSpan();
        if (activeSpan != null) {
            return activeSpan.context();
        }
        return this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new ServerHeadersExtractTextMap((MultivaluedMap<String, String>)requestContext.getHeaders()));
    }

    private void decorateRequest(ContainerRequestContext requestContext, Span span) {
        Tags.COMPONENT.set(span, "jersey-server");
        Tags.HTTP_METHOD.set(span, requestContext.getMethod());
        String urlStr = null;
        try {
            URL url = requestContext.getUriInfo().getRequestUri().toURL();
            urlStr = url.toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (urlStr != null) {
            Tags.HTTP_URL.set(span, urlStr);
        }
    }

    private void decorateResponse(ContainerResponseContext responseContext, Span span) {
        Tags.HTTP_STATUS.set(span, Integer.valueOf(responseContext.getStatus()));
        if (this.isErrorStatusCode(responseContext)) {
            Tags.ERROR.set(span, Boolean.valueOf(true));
        }
    }

    private boolean isErrorStatusCode(ContainerResponseContext containerResponseContext) {
        int statusCode = containerResponseContext.getStatus();
        return statusCode >= 400 && statusCode <= 599;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    private class StatsContext {
        private final long startTime;
        private final long startCpuNanos;
        @Nullable
        private final AtomicInteger apiInflight;
        @Nullable
        private final AtomicInteger totalInflight;

        StatsContext(long startTime, long startCpuNanos, AtomicInteger apiInflight, AtomicInteger totalInflight) {
            this.startTime = startTime;
            this.startCpuNanos = startCpuNanos;
            this.apiInflight = apiInflight;
            this.totalInflight = totalInflight;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getStartCpuNanos() {
            return this.startCpuNanos;
        }

        public AtomicInteger getApiInflight() {
            return this.apiInflight;
        }

        public AtomicInteger getTotalInflight() {
            return this.totalInflight;
        }
    }

    public static final class MultivaluedMapFlatIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, List<V>>> mapIterator;
        private Map.Entry<K, List<V>> mapEntry;
        private Iterator listIterator;

        MultivaluedMapFlatIterator(Set<Map.Entry<K, List<V>>> multiValuesEntrySet) {
            this.mapIterator = multiValuesEntrySet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.listIterator != null && this.listIterator.hasNext() || this.mapIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.mapEntry == null || !this.listIterator.hasNext() && this.mapIterator.hasNext()) {
                this.mapEntry = this.mapIterator.next();
                this.listIterator = this.mapEntry.getValue().iterator();
            }
            return this.listIterator.hasNext() ? new AbstractMap.SimpleImmutableEntry(this.mapEntry.getKey(), this.listIterator.next()) : new AbstractMap.SimpleImmutableEntry<K, Object>(this.mapEntry.getKey(), null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class ServerHeadersExtractTextMap
    implements TextMap {
        private final MultivaluedMap<String, String> headers;

        ServerHeadersExtractTextMap(MultivaluedMap<String, String> headers) {
            this.headers = headers;
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            return new MultivaluedMapFlatIterator<String, String>(this.headers.entrySet());
        }

        public void put(String key, String value) {
            throw new UnsupportedOperationException(ServerHeadersExtractTextMap.class.getName() + " should only be used with Tracer.extract()");
        }
    }

    public static final class Builder {
        private final SdkReporter wfJerseyReporter;
        private final ApplicationTags applicationTags;
        private final Set<String> headerTags = new HashSet<String>();
        @Nullable
        private Tracer tracer;

        public Builder(SdkReporter wfJerseyReporter, ApplicationTags applicationTags) {
            this.wfJerseyReporter = wfJerseyReporter;
            this.applicationTags = applicationTags;
        }

        public Builder withTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder headerTags(Set<String> headerTags) {
            this.headerTags.addAll(headerTags);
            return this;
        }

        public WavefrontJerseyFilter build() {
            return new WavefrontJerseyFilter(this.wfJerseyReporter, this.applicationTags, this.tracer, this.headerTags);
        }
    }
}

