/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.jersey;

import com.wavefront.config.ReportingUtils;
import com.wavefront.config.WavefrontReportingConfig;
import com.wavefront.opentracing.WavefrontTracer;
import com.wavefront.opentracing.reporting.Reporter;
import com.wavefront.opentracing.reporting.WavefrontSpanReporter;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.jaxrs.client.WavefrontJaxrsClientFilter;
import com.wavefront.sdk.jersey.WavefrontJerseyFilter;
import com.wavefront.sdk.jersey.reporter.WavefrontJerseyReporter;
import io.opentracing.Tracer;
import org.apache.commons.lang3.BooleanUtils;

public class WavefrontJerseyFactory {
    private final ApplicationTags applicationTags;
    private final String source;
    private final Tracer tracer;
    private final WavefrontSender wavefrontSender;
    private final WavefrontJerseyReporter wfJerseyReporter;
    private final WavefrontJerseyFilter wavefrontJerseyFilter;
    private final WavefrontJaxrsClientFilter wavefrontJaxrsClientFilter;

    public WavefrontJerseyFactory(String applicationTagsYamlFile, String wfReportingConfigYamlFile) {
        this.applicationTags = ReportingUtils.constructApplicationTags((String)applicationTagsYamlFile);
        WavefrontReportingConfig wfReportingConfig = ReportingUtils.constructWavefrontReportingConfig((String)wfReportingConfigYamlFile);
        this.source = wfReportingConfig.getSource();
        this.wavefrontSender = ReportingUtils.constructWavefrontSender((WavefrontReportingConfig)wfReportingConfig);
        this.wfJerseyReporter = new WavefrontJerseyReporter.Builder(this.applicationTags).withSource(this.source).build(this.wavefrontSender);
        WavefrontJerseyFilter.Builder wfJerseyFilterBuilder = new WavefrontJerseyFilter.Builder(this.wfJerseyReporter, this.applicationTags);
        if (BooleanUtils.isTrue((Boolean)wfReportingConfig.getReportTraces())) {
            WavefrontSpanReporter wfSpanReporter = new WavefrontSpanReporter.Builder().withSource(this.source).build(this.wavefrontSender);
            this.tracer = new WavefrontTracer.Builder((Reporter)wfSpanReporter, this.applicationTags).build();
            wfJerseyFilterBuilder.withTracer(this.tracer);
        } else {
            this.tracer = null;
        }
        this.wfJerseyReporter.start();
        this.wavefrontJerseyFilter = wfJerseyFilterBuilder.build();
        this.wavefrontJaxrsClientFilter = new WavefrontJaxrsClientFilter(this.wavefrontSender, this.applicationTags, this.source, this.tracer);
    }

    public WavefrontJerseyFilter getWavefrontJerseyFilter() {
        return this.wavefrontJerseyFilter;
    }

    public WavefrontJaxrsClientFilter getWavefrontJaxrsClientFilter() {
        return this.wavefrontJaxrsClientFilter;
    }

    public ApplicationTags getApplicationTags() {
        return this.applicationTags;
    }

    public String getSource() {
        return this.source;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public WavefrontSender getWavefrontSender() {
        return this.wavefrontSender;
    }

    public WavefrontJerseyReporter getWavefrontJerseyReporter() {
        return this.wfJerseyReporter;
    }
}

