/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.jaxrs.server;

import com.wavefront.config.ReportingUtils;
import com.wavefront.config.WavefrontReportingConfig;
import com.wavefront.opentracing.WavefrontTracer;
import com.wavefront.opentracing.reporting.Reporter;
import com.wavefront.opentracing.reporting.WavefrontSpanReporter;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.jaxrs.reporter.WavefrontJaxrsReporter;
import com.wavefront.sdk.jaxrs.server.WavefrontJaxrsServerFilter;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.util.Set;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.BooleanUtils;

@Provider
public class WavefrontJaxrsDynamicFeature
implements DynamicFeature {
    private final WavefrontJaxrsServerFilter.Builder wfJaxrsFilterBuilder;
    private final WavefrontJaxrsReporter wavefrontJaxrsReporter;
    private Tracer tracer;

    public WavefrontJaxrsDynamicFeature(ApplicationTags applicationTags, WavefrontReportingConfig wavefrontReportingConfig, Set<String> headerTags) {
        String source = wavefrontReportingConfig.getSource();
        WavefrontSender wavefrontSender = ReportingUtils.constructWavefrontSender((WavefrontReportingConfig)wavefrontReportingConfig);
        this.wavefrontJaxrsReporter = new WavefrontJaxrsReporter.Builder(applicationTags).withSource(source).build(wavefrontSender);
        this.wfJaxrsFilterBuilder = new WavefrontJaxrsServerFilter.Builder(this.wavefrontJaxrsReporter, applicationTags);
        if (BooleanUtils.isTrue((Boolean)wavefrontReportingConfig.getReportTraces())) {
            WavefrontSpanReporter wfSpanReporter = new WavefrontSpanReporter.Builder().withSource(source).build(wavefrontSender);
            this.tracer = new WavefrontTracer.Builder((Reporter)wfSpanReporter, applicationTags).build();
            this.wfJaxrsFilterBuilder.withTracer(this.tracer);
            this.wfJaxrsFilterBuilder.headerTags(headerTags);
            GlobalTracer.register((Tracer)this.tracer);
        }
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        this.wavefrontJaxrsReporter.start();
        featureContext.register((Object)this.wfJaxrsFilterBuilder.build());
    }

    public Tracer getTracer() {
        return this.tracer;
    }
}

