/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.jaxrs.server;

import com.wavefront.sdk.common.Pair;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import org.apache.commons.lang3.StringUtils;

abstract class MetricNameUtils {
    MetricNameUtils() {
    }

    static Optional<Pair<String, String>> metricNameAndPath(ContainerRequestContext request, ResourceInfo resourceInfo) {
        Class clazz = resourceInfo.getResourceClass();
        String classPath = MetricNameUtils.extractPath(clazz.getAnnotation(Path.class));
        Method method = resourceInfo.getResourceMethod();
        String methodPath = MetricNameUtils.extractPath(method.getAnnotation(Path.class));
        if (classPath.isEmpty() || methodPath.isEmpty()) {
            Class<?>[] interfaces;
            for (Class<?> c : interfaces = clazz.getInterfaces()) {
                try {
                    Method declaringMethod = c.getMethod(method.getName(), method.getParameterTypes());
                    if (classPath.isEmpty()) {
                        classPath = MetricNameUtils.extractPath(c.getAnnotation(Path.class));
                    }
                    if (!methodPath.isEmpty()) continue;
                    methodPath = MetricNameUtils.extractPath(declaringMethod.getAnnotation(Path.class));
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
        String path = classPath + methodPath;
        Optional<String> optionalMetricName = MetricNameUtils.metricName(request.getMethod(), path);
        String matchingPath = MetricNameUtils.stripLeadingAndTrailingSlashes(path);
        return optionalMetricName.map(metricName -> new Pair(metricName, (Object)matchingPath));
    }

    private static Optional<String> metricName(String httpMethod, String path) {
        String metricId = MetricNameUtils.stripLeadingAndTrailingSlashes(path);
        if (StringUtils.isBlank((CharSequence)(metricId = metricId.replace('/', '.').replace(":", "").replace("{", "_").replace("}", "_")))) {
            return Optional.empty();
        }
        return Optional.of(metricId + "." + httpMethod);
    }

    private static String stripLeadingAndTrailingSlashes(String path) {
        return path == null ? "" : StringUtils.strip((String)path, (String)"/");
    }

    private static String extractPath(Path path) {
        return path == null ? "" : path.value();
    }
}

