/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.jaxrs.reporter;

import com.wavefront.internal.reporter.SdkReporter;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.common.application.HeartbeaterService;
import com.wavefront.sdk.entities.metrics.WavefrontMetricSender;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public class WavefrontJaxrsReporter
implements SdkReporter {
    private final WavefrontInternalReporter wfReporter;
    private final WavefrontInternalReporter sdkMetricsReporter;
    private final int reportingIntervalSeconds;
    private final HeartbeaterService heartbeaterService;

    @Deprecated
    private WavefrontJaxrsReporter(WavefrontInternalReporter wfReporter, int reportingIntervalSeconds, WavefrontMetricSender wavefrontMetricSender, ApplicationTags applicationTags, String source) {
        this(wfReporter, reportingIntervalSeconds, wavefrontMetricSender, applicationTags, source, null);
    }

    private WavefrontJaxrsReporter(WavefrontInternalReporter wfReporter, int reportingIntervalSeconds, WavefrontMetricSender wavefrontMetricSender, ApplicationTags applicationTags, String source, WavefrontInternalReporter sdkMetricsReporter) {
        if (wfReporter == null) {
            throw new NullPointerException("Invalid wfReporter");
        }
        if (wavefrontMetricSender == null) {
            throw new NullPointerException("Invalid wavefrontSender");
        }
        if (applicationTags == null) {
            throw new NullPointerException("Invalid ApplicationTags");
        }
        this.wfReporter = wfReporter;
        this.reportingIntervalSeconds = reportingIntervalSeconds;
        this.sdkMetricsReporter = sdkMetricsReporter;
        this.heartbeaterService = new HeartbeaterService(wavefrontMetricSender, applicationTags, Collections.singletonList("jaxrs-server"), source);
    }

    public void incrementCounter(MetricName metricName) {
        this.wfReporter.newCounter(metricName).inc();
    }

    public void incrementCounter(MetricName metricName, long l) {
        this.wfReporter.newCounter(metricName).inc(l);
    }

    public void incrementDeltaCounter(MetricName metricName) {
        this.wfReporter.newDeltaCounter(metricName).inc();
    }

    public void registerGauge(MetricName metricName, AtomicInteger value) {
        this.wfReporter.newGauge(metricName, () -> () -> (double)value.get());
    }

    public void updateHistogram(MetricName metricName, long latencyMillis) {
        this.wfReporter.newWavefrontHistogram(metricName).update(latencyMillis);
    }

    public void start() {
        this.wfReporter.start((long)this.reportingIntervalSeconds, TimeUnit.SECONDS);
        if (this.sdkMetricsReporter != null) {
            this.sdkMetricsReporter.start(1L, TimeUnit.MINUTES);
        }
    }

    public void stop() {
        this.heartbeaterService.close();
        this.wfReporter.stop();
        if (this.sdkMetricsReporter != null) {
            this.sdkMetricsReporter.stop();
        }
    }

    public static class Builder {
        private final ApplicationTags applicationTags;
        private final String prefix = "jaxrs.server";
        private int reportingIntervalSeconds = 60;
        @Nullable
        private String source;

        public Builder(ApplicationTags applicationTags) {
            this.applicationTags = applicationTags;
        }

        public Builder reportingIntervalSeconds(int reportingIntervalSeconds) {
            this.reportingIntervalSeconds = reportingIntervalSeconds;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        public WavefrontJaxrsReporter build(WavefrontSender wavefrontSender) {
            if (this.source == null) {
                try {
                    this.source = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    this.source = "unknown";
                }
            }
            HashMap<String, String> pointTags = new HashMap<String, String>();
            pointTags.put("application", this.applicationTags.getApplication());
            if (this.applicationTags.getCustomTags() != null) {
                pointTags.putAll(this.applicationTags.getCustomTags());
            }
            WavefrontInternalReporter wfReporter = new WavefrontInternalReporter.Builder().prefixedWith("jaxrs.server").withSource(this.source).withReporterPointTags(pointTags).reportMinuteDistribution().build(wavefrontSender);
            WavefrontInternalReporter sdkMetricsReporter = new WavefrontInternalReporter.Builder().prefixedWith("~sdk.java.jaxrs").withSource(this.source).withReporterPointTags(pointTags).build(wavefrontSender);
            double sdkVersion = Utils.getSemVerGauge((String)"wavefront-jaxrs-sdk-java");
            sdkMetricsReporter.newGauge(new MetricName("version", Collections.emptyMap()), () -> () -> sdkVersion);
            return new WavefrontJaxrsReporter(wfReporter, this.reportingIntervalSeconds, (WavefrontMetricSender)wavefrontSender, this.applicationTags, this.source, sdkMetricsReporter);
        }
    }
}

