/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.jaxrs.client;

import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.common.application.HeartbeaterService;
import com.wavefront.sdk.entities.metrics.WavefrontMetricSender;
import com.wavefront.sdk.jaxrs.Constants;
import com.wavefront.sdk.jaxrs.client.ClientHeadersInjectTextMap;
import com.wavefront.sdk.jaxrs.client.ClientSpanDecorator;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;

public class WavefrontJaxrsClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    @Nullable
    private final Tracer tracer;
    private final List<ClientSpanDecorator> spanDecorators;

    public WavefrontJaxrsClientFilter(WavefrontSender wfSender, ApplicationTags applicationTags, @Nonnull String source, @Nullable Tracer tracer) {
        this.tracer = tracer;
        this.spanDecorators = Arrays.asList(ClientSpanDecorator.STANDARD_TAGS, ClientSpanDecorator.WF_PATH_OPERATION_NAME);
        HeartbeaterService heartbeaterService = new HeartbeaterService((WavefrontMetricSender)wfSender, applicationTags, Collections.singletonList("jaxrs-client"), source);
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (requestContext.getProperty(Constants.PROPERTY_NAME) != null) {
            return;
        }
        if (this.tracer != null) {
            Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(requestContext.getMethod()).withTag(Tags.SPAN_KIND.getKey(), "client");
            SpanContext parentSpanContext = (SpanContext)requestContext.getProperty(Constants.CHILD_OF);
            if (parentSpanContext != null) {
                spanBuilder.ignoreActiveSpan().asChildOf(parentSpanContext);
            }
            Span span = spanBuilder.start();
            for (ClientSpanDecorator decorator : this.spanDecorators) {
                decorator.decorateRequest(requestContext, span);
            }
            this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new ClientHeadersInjectTextMap((MultivaluedMap<String, Object>)requestContext.getHeaders()));
            requestContext.setProperty(Constants.PROPERTY_NAME, (Object)span);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        Span span;
        if (this.tracer != null && (span = (Span)requestContext.getProperty(Constants.PROPERTY_NAME)) != null) {
            for (ClientSpanDecorator decorator : this.spanDecorators) {
                decorator.decorateResponse(responseContext, span);
            }
            span.finish();
        }
    }
}

