/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.jaxrs.client;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.net.MalformedURLException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;

public interface ClientSpanDecorator {
    public static final ClientSpanDecorator STANDARD_TAGS = new ClientSpanDecorator(){

        @Override
        public void decorateRequest(ClientRequestContext requestContext, Span span) {
            Tags.COMPONENT.set(span, "jaxrs-client");
            Tags.HTTP_METHOD.set(span, requestContext.getMethod());
            try {
                Tags.HTTP_URL.set(span, requestContext.getUri().toURL().toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        @Override
        public void decorateResponse(ClientResponseContext responseContext, Span span) {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(responseContext.getStatus()));
            int statusCode = responseContext.getStatus();
            if (statusCode >= 400 && statusCode <= 599) {
                Tags.ERROR.set(span, Boolean.valueOf(true));
            }
        }
    };
    public static final ClientSpanDecorator WF_PATH_OPERATION_NAME = new ClientSpanDecorator(){
        ThreadLocal<String> methodName = new ThreadLocal();

        @Override
        public void decorateRequest(ClientRequestContext clientRequestContext, Span span) {
            this.methodName.set(clientRequestContext.getMethod());
        }

        @Override
        public void decorateResponse(ClientResponseContext response, Span span) {
            String operationName = this.methodName.get();
            if (response.getHeaders().containsKey((Object)"X-WF-SPAN-NAME")) {
                operationName = operationName + "-" + String.valueOf(response.getHeaders().getFirst((Object)"X-WF-SPAN-NAME"));
            }
            span.setOperationName(operationName);
        }
    };

    public void decorateRequest(ClientRequestContext var1, Span var2);

    public void decorateResponse(ClientResponseContext var1, Span var2);
}

