/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.grpc.reporter;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.internal.reporter.SdkReporter;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.common.application.HeartbeaterService;
import com.wavefront.sdk.entities.metrics.WavefrontMetricSender;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class WavefrontGrpcReporter
implements SdkReporter {
    private static final Logger logger = Logger.getLogger(WavefrontGrpcReporter.class.getCanonicalName());
    private final int reportingIntervalSeconds;
    private final WavefrontInternalReporter wfReporter;
    private final WavefrontInternalReporter sdkMetricsReporter;
    private final WavefrontMetricSender wfMetricSender;
    private final ApplicationTags applicationTags;
    private final String source;
    private HeartbeaterService clientHeartbeat;
    private HeartbeaterService serverHeartbeat;

    @Deprecated
    @VisibleForTesting
    WavefrontGrpcReporter(WavefrontInternalReporter wfReporter, int reportingIntervalSeconds, WavefrontMetricSender wfMetricSender, ApplicationTags applicationTags, String source) {
        this(wfReporter, reportingIntervalSeconds, wfMetricSender, applicationTags, source, null);
    }

    @VisibleForTesting
    WavefrontGrpcReporter(WavefrontInternalReporter wfReporter, int reportingIntervalSeconds, WavefrontMetricSender wfMetricSender, ApplicationTags applicationTags, String source, WavefrontInternalReporter sdkMetricsReporter) {
        this.wfReporter = wfReporter;
        this.reportingIntervalSeconds = reportingIntervalSeconds;
        this.wfMetricSender = wfMetricSender;
        this.applicationTags = applicationTags;
        this.source = source;
        this.sdkMetricsReporter = sdkMetricsReporter;
    }

    public void incrementCounter(MetricName metricName) {
        this.wfReporter.newCounter(metricName).inc();
    }

    public void incrementCounter(MetricName metricName, long incrementValue) {
        this.wfReporter.newCounter(metricName).inc(incrementValue);
    }

    public void incrementDeltaCounter(MetricName metricName) {
        this.wfReporter.newDeltaCounter(metricName).inc();
    }

    public void registerGauge(MetricName metricName, Supplier<Double> value) {
        this.wfReporter.newGauge(metricName, () -> ((Supplier)value)::get);
    }

    public void updateHistogram(MetricName metricName, long latencyMillis) {
        this.wfReporter.newWavefrontHistogram(metricName).update(latencyMillis);
    }

    public void registerGauge(MetricName metricName, AtomicInteger atomicInteger) {
        this.wfReporter.newGauge(metricName, () -> () -> (double)atomicInteger.get());
    }

    public void start() {
        this.wfReporter.start((long)this.reportingIntervalSeconds, TimeUnit.SECONDS);
        if (this.sdkMetricsReporter != null) {
            this.sdkMetricsReporter.start(1L, TimeUnit.MINUTES);
        }
    }

    public void stop() {
        if (this.serverHeartbeat != null) {
            this.serverHeartbeat.close();
        }
        if (this.clientHeartbeat != null) {
            this.clientHeartbeat.close();
        }
        if (this.wfReporter != null) {
            this.wfReporter.stop();
        }
        if (this.sdkMetricsReporter != null) {
            this.sdkMetricsReporter.stop();
        }
    }

    public synchronized void registerServerHeartBeat() {
        if (this.serverHeartbeat == null) {
            this.serverHeartbeat = new HeartbeaterService(this.wfMetricSender, this.applicationTags, Collections.singletonList("grpc-server"), this.source);
        }
    }

    public synchronized void registerClientHeartbeat() {
        if (this.clientHeartbeat == null) {
            this.clientHeartbeat = new HeartbeaterService(this.wfMetricSender, this.applicationTags, Collections.singletonList("grpc-client"), this.source);
        }
    }

    public static class Builder {
        private final ApplicationTags applicationTags;
        private final String prefix = "grpc";
        private int reportingIntervalSeconds = 60;
        @Nullable
        private String source;

        public Builder(ApplicationTags applicationTags) {
            this.applicationTags = applicationTags;
        }

        public Builder reportingIntervalSeconds(int reportingIntervalSeconds) {
            this.reportingIntervalSeconds = reportingIntervalSeconds;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        public WavefrontGrpcReporter build(WavefrontSender wavefrontSender) {
            if (this.source == null) {
                try {
                    this.source = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    logger.log(Level.SEVERE, "source name not known, setting to unknown", e);
                    this.source = "unknown";
                }
            }
            HashMap<String, String> pointTags = new HashMap<String, String>();
            pointTags.put("application", this.applicationTags.getApplication());
            if (this.applicationTags.getCustomTags() != null) {
                pointTags.putAll(this.applicationTags.getCustomTags());
            }
            WavefrontInternalReporter wfReporter = new WavefrontInternalReporter.Builder().prefixedWith("grpc").withSource(this.source).withReporterPointTags(pointTags).reportMinuteDistribution().build(wavefrontSender);
            WavefrontInternalReporter sdkMetricsReporter = new WavefrontInternalReporter.Builder().prefixedWith("~sdk.java.grpc").withSource(this.source).withReporterPointTags(pointTags).build(wavefrontSender);
            double sdkVersion = Utils.getSemVerGauge((String)"wavefront-grpc-sdk-java");
            sdkMetricsReporter.newGauge(new MetricName("version", Collections.emptyMap()), () -> () -> sdkVersion);
            return new WavefrontGrpcReporter(wfReporter, this.reportingIntervalSeconds, (WavefrontMetricSender)wavefrontSender, this.applicationTags, this.source, sdkMetricsReporter);
        }
    }
}

