/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.grpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.grpc.Utils;
import com.wavefront.sdk.grpc.reporter.WavefrontGrpcReporter;
import io.grpc.Metadata;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.annotation.Nullable;

public class WavefrontServerTracerFactory
extends ServerStreamTracer.Factory {
    private static final String REQUEST_PREFIX = "server.request.";
    private static final String RESPONSE_PREFIX = "server.response.";
    private static final String SERVER_PREFIX = "server.";
    private static final String SERVER_TOTAL_INFLIGHT = "server.total_requests.inflight";
    private final Map<MetricName, AtomicInteger> gauges = new ConcurrentHashMap<MetricName, AtomicInteger>();
    private final WavefrontGrpcReporter wfGrpcReporter;
    @Nullable
    private final Tracer tracer;
    @Nullable
    private final Function<String, String> spanNameOverride;
    private final ApplicationTags applicationTags;
    private final boolean recordStreamingStats;

    private WavefrontServerTracerFactory(WavefrontGrpcReporter wfGrpcReporter, Tracer tracer, ApplicationTags applicationTags, boolean recordStreamingStats, Function<String, String> spanNameOverride) {
        this.wfGrpcReporter = wfGrpcReporter;
        this.tracer = tracer;
        this.applicationTags = applicationTags;
        this.recordStreamingStats = recordStreamingStats;
        this.spanNameOverride = spanNameOverride;
        wfGrpcReporter.registerServerHeartBeat();
    }

    public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
        String methodName = Utils.getFriendlyMethodName(fullMethodName);
        methodName = this.spanNameOverride != null ? this.spanNameOverride.apply(methodName) : methodName;
        return new ServerTracer(Utils.getServiceName(fullMethodName), methodName, this.createServerSpan(headers, methodName));
    }

    private Span createServerSpan(Metadata headers, String methodName) {
        Span span;
        if (this.tracer == null) {
            return null;
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String key : headers.keys()) {
            if (key.endsWith("-bin")) continue;
            String value = (String)headers.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            headerMap.put(key, value);
        }
        String spanName = methodName;
        try {
            SpanContext parentSpanCtx = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter(headerMap));
            span = parentSpanCtx == null ? this.tracer.buildSpan(spanName).start() : this.tracer.buildSpan(spanName).asChildOf(parentSpanCtx).start();
        }
        catch (IllegalArgumentException iae) {
            span = this.tracer.buildSpan(spanName).withTag("Error", "Extract failed and an IllegalArgumentException was thrown").start();
        }
        Tags.SPAN_KIND.set(span, "server");
        Tags.COMPONENT.set(span, "grpc-server");
        return span;
    }

    private AtomicInteger getGaugeValue(MetricName metricName) {
        return this.gauges.computeIfAbsent(metricName, key -> {
            AtomicInteger toReturn = new AtomicInteger();
            this.wfGrpcReporter.registerGauge((MetricName)key, () -> toReturn.get());
            return toReturn;
        });
    }

    private class ServerTracer
    extends ServerStreamTracer {
        private final String grpcService;
        private final String methodName;
        @Nullable
        private final Span span;
        private AtomicBoolean streamingMethod = new AtomicBoolean(false);
        private final AtomicBoolean streamClosed = new AtomicBoolean(false);
        @Nullable
        private final AtomicLong requestMessageCount;
        @Nullable
        private final AtomicLong responseMessageCount;
        private final AtomicLong requestBytes = new AtomicLong(0L);
        private final AtomicLong responseBytes = new AtomicLong(0L);
        private final long startTime = System.currentTimeMillis();
        private final Map<String, String> allTags;
        private final Map<String, String> overallAggregatedPerSourceTags;
        private final Map<String, String> histogramAllTags;

        ServerTracer(String grpcService, String methodName, Span span) {
            this.grpcService = grpcService;
            this.methodName = methodName;
            this.span = span;
            this.requestMessageCount = new AtomicLong(0L);
            this.responseMessageCount = new AtomicLong(0L);
            ImmutableMap.Builder tagsBuilder = ImmutableMap.builder().put((Object)"cluster", (Object)(WavefrontServerTracerFactory.this.applicationTags.getCluster() == null ? "none" : WavefrontServerTracerFactory.this.applicationTags.getCluster())).put((Object)"service", (Object)WavefrontServerTracerFactory.this.applicationTags.getService()).put((Object)"shard", (Object)(WavefrontServerTracerFactory.this.applicationTags.getShard() == null ? "none" : WavefrontServerTracerFactory.this.applicationTags.getShard()));
            this.overallAggregatedPerSourceTags = tagsBuilder.build();
            this.allTags = tagsBuilder.put((Object)"grpc.service", (Object)grpcService).build();
            this.histogramAllTags = tagsBuilder.put((Object)"grpc.method", (Object)methodName).build();
            WavefrontServerTracerFactory.this.getGaugeValue(new MetricName(WavefrontServerTracerFactory.REQUEST_PREFIX + methodName + ".inflight", this.allTags)).incrementAndGet();
            WavefrontServerTracerFactory.this.getGaugeValue(new MetricName(WavefrontServerTracerFactory.SERVER_TOTAL_INFLIGHT, this.overallAggregatedPerSourceTags)).incrementAndGet();
        }

        public void serverCallStarted(ServerStreamTracer.ServerCallInfo<?, ?> callInfo) {
            this.streamingMethod.set(Utils.isStreamingMethod(callInfo.getMethodDescriptor().getType()));
            if (this.span != null) {
                this.span.setTag("grpc.method_type", callInfo.getMethodDescriptor().getType().toString());
            }
        }

        public void outboundWireSize(long bytes) {
            this.responseBytes.addAndGet(bytes);
        }

        public void inboundWireSize(long bytes) {
            this.requestBytes.addAndGet(bytes);
        }

        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            if (this.shouldRecordStreamingStats()) {
                this.requestMessageCount.incrementAndGet();
                if (optionalWireSize >= 0L) {
                    WavefrontServerTracerFactory.this.wfGrpcReporter.updateHistogram(new MetricName(WavefrontServerTracerFactory.REQUEST_PREFIX + this.methodName + ".streaming.message_bytes", this.histogramAllTags), optionalWireSize);
                }
            }
        }

        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            if (this.shouldRecordStreamingStats()) {
                this.responseMessageCount.incrementAndGet();
                if (optionalWireSize >= 0L) {
                    WavefrontServerTracerFactory.this.wfGrpcReporter.updateHistogram(new MetricName(WavefrontServerTracerFactory.RESPONSE_PREFIX + this.methodName + ".streaming.message_bytes", this.histogramAllTags), optionalWireSize);
                }
            }
        }

        public void streamClosed(Status status) {
            if (this.streamClosed.getAndSet(true)) {
                return;
            }
            long rpcLatency = System.currentTimeMillis() - this.startTime;
            this.finishServerSpan(status);
            WavefrontServerTracerFactory.this.getGaugeValue(new MetricName(WavefrontServerTracerFactory.REQUEST_PREFIX + this.methodName + ".inflight", this.allTags)).decrementAndGet();
            WavefrontServerTracerFactory.this.getGaugeValue(new MetricName(WavefrontServerTracerFactory.SERVER_TOTAL_INFLIGHT, this.overallAggregatedPerSourceTags)).decrementAndGet();
            Utils.reportLatency(WavefrontServerTracerFactory.SERVER_PREFIX, this.methodName, status, rpcLatency, this.histogramAllTags, this.allTags, WavefrontServerTracerFactory.this.wfGrpcReporter);
            Utils.reportRpcRequestBytes(WavefrontServerTracerFactory.SERVER_PREFIX, this.methodName, this.requestBytes.get(), this.histogramAllTags, this.allTags, WavefrontServerTracerFactory.this.wfGrpcReporter);
            Utils.reportRpcResponseBytes(WavefrontServerTracerFactory.SERVER_PREFIX, this.methodName, this.responseBytes.get(), this.histogramAllTags, this.allTags, WavefrontServerTracerFactory.this.wfGrpcReporter);
            if (this.shouldRecordStreamingStats()) {
                Utils.reportRequestMessageCount(WavefrontServerTracerFactory.SERVER_PREFIX, this.methodName, this.requestMessageCount.get(), this.allTags, this.histogramAllTags, WavefrontServerTracerFactory.this.wfGrpcReporter);
                Utils.reportResponseMessageCount(WavefrontServerTracerFactory.SERVER_PREFIX, this.methodName, this.responseMessageCount.get(), this.allTags, this.histogramAllTags, WavefrontServerTracerFactory.this.wfGrpcReporter);
            }
            Utils.reportResponseAndErrorStats(WavefrontServerTracerFactory.SERVER_PREFIX, this.methodName, this.grpcService, status, WavefrontServerTracerFactory.this.applicationTags, this.allTags, this.overallAggregatedPerSourceTags, WavefrontServerTracerFactory.this.wfGrpcReporter);
        }

        private void finishServerSpan(Status status) {
            if (this.span != null) {
                this.span.setTag("grpc.status", status.getCode().toString());
                if (status.getCode() != Status.Code.OK) {
                    Tags.ERROR.set(this.span, Boolean.valueOf(true));
                }
                this.span.setTag("request.bytes", (Number)this.requestBytes.get());
                this.span.setTag("response.bytes", (Number)this.responseBytes.get());
                if (this.shouldRecordStreamingStats()) {
                    this.span.setTag("request.messages.count", (Number)this.requestMessageCount.get());
                    this.span.setTag("response.messages.count", (Number)this.responseMessageCount.get());
                }
                this.span.finish();
            }
        }

        private boolean shouldRecordStreamingStats() {
            return WavefrontServerTracerFactory.this.recordStreamingStats && this.streamingMethod.get();
        }
    }

    public static class Builder {
        private WavefrontGrpcReporter wfGrpcReporter;
        @Nullable
        private Tracer tracer;
        @Nullable
        private Function<String, String> spanNameOverride;
        private ApplicationTags applicationTags;
        boolean recordStreamingStats = false;

        public Builder(WavefrontGrpcReporter wfGrpcReporter, ApplicationTags applicationTags) {
            this.wfGrpcReporter = (WavefrontGrpcReporter)Preconditions.checkNotNull((Object)wfGrpcReporter, (Object)"invalid reporter");
            this.applicationTags = (ApplicationTags)Preconditions.checkNotNull((Object)applicationTags, (Object)"invalid app tags");
        }

        public Builder recordStreamingStats() {
            this.recordStreamingStats = true;
            return this;
        }

        public Builder withTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder spanNameOverride(Function<String, String> fullMethodNameTransform) {
            this.spanNameOverride = fullMethodNameTransform;
            return this;
        }

        public WavefrontServerTracerFactory build() {
            return new WavefrontServerTracerFactory(this.wfGrpcReporter, this.tracer, this.applicationTags, this.recordStreamingStats, this.spanNameOverride);
        }
    }
}

