/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.grpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.grpc.Constants;
import com.wavefront.sdk.grpc.Utils;
import com.wavefront.sdk.grpc.reporter.WavefrontGrpcReporter;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientStreamTracer;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.annotation.Nullable;

public class WavefrontClientInterceptor
implements ClientInterceptor {
    private static final String REQUEST_PREFIX = "client.request.";
    private static final String RESPONSE_PREFIX = "client.response.";
    private static final String CLIENT_PREFIX = "client.";
    private static final String CLIENT_TOTAL_INFLIGHT = "client.total_requests.inflight";
    private final Map<MetricName, AtomicInteger> gauges = new ConcurrentHashMap<MetricName, AtomicInteger>();
    private final WavefrontGrpcReporter wfGrpcReporter;
    @Nullable
    private final Tracer tracer;
    @Nullable
    private final Function<String, String> spanNameOverride;
    private final ApplicationTags applicationTags;
    private final boolean recordStreamingStats;

    private WavefrontClientInterceptor(WavefrontGrpcReporter wfGrpcReporter, Tracer tracer, ApplicationTags applicationTags, boolean recordStreamingStats, Function<String, String> spanNameOverride) {
        this.wfGrpcReporter = wfGrpcReporter;
        this.tracer = tracer;
        this.applicationTags = applicationTags;
        this.recordStreamingStats = recordStreamingStats;
        this.spanNameOverride = spanNameOverride;
        wfGrpcReporter.registerClientHeartbeat();
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        String methodName = Utils.getFriendlyMethodName(method.getFullMethodName());
        methodName = this.spanNameOverride != null ? this.spanNameOverride.apply(methodName) : methodName;
        Span span = this.createClientSpan(methodName, method.getType().toString());
        final ClientCallTracer tracerFactory = new ClientCallTracer(Utils.getServiceName(method.getFullMethodName()), methodName, this.shouldRecordStreamingStats(method.getType()), span);
        ClientCall call = next.newCall(method, callOptions.withStreamTracerFactory((ClientStreamTracer.Factory)tracerFactory));
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                this.delegate().start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onClose(Status status, Metadata trailers) {
                        tracerFactory.callEnded(status);
                        super.onClose(status, trailers);
                    }
                }, headers);
            }
        };
    }

    @Nullable
    private Span createClientSpan(String methodName, String methodType) {
        if (this.tracer == null) {
            return null;
        }
        Span activeSpan = (Span)Constants.GRPC_CONTEXT_SPAN_KEY.get();
        String spanName = methodName;
        Span toReturn = activeSpan != null ? this.tracer.buildSpan(spanName).asChildOf(activeSpan.context()).start() : this.tracer.buildSpan(spanName).start();
        Tags.SPAN_KIND.set(toReturn, "client");
        Tags.COMPONENT.set(toReturn, "grpc-client");
        toReturn.setTag("grpc.method_type", methodType);
        return toReturn;
    }

    private boolean shouldRecordStreamingStats(MethodDescriptor.MethodType methodType) {
        if (this.recordStreamingStats) {
            return Utils.isStreamingMethod(methodType);
        }
        return false;
    }

    private AtomicInteger getGaugeValue(MetricName metricName) {
        return this.gauges.computeIfAbsent(metricName, key -> {
            AtomicInteger toReturn = new AtomicInteger();
            this.wfGrpcReporter.registerGauge((MetricName)key, () -> toReturn.get());
            return toReturn;
        });
    }

    private class ClientTracer
    extends ClientStreamTracer {
        private final ClientCallTracer callTracer;

        ClientTracer(ClientCallTracer callTracer) {
            this.callTracer = callTracer;
        }

        public void outboundWireSize(long bytes) {
            this.callTracer.requestBytes.addAndGet(bytes);
        }

        public void inboundWireSize(long bytes) {
            this.callTracer.responseBytes.addAndGet(bytes);
        }

        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            if (this.callTracer.streamingStats) {
                this.callTracer.requestMessageCount.incrementAndGet();
                if (optionalWireSize >= 0L) {
                    WavefrontClientInterceptor.this.wfGrpcReporter.updateHistogram(new MetricName(WavefrontClientInterceptor.REQUEST_PREFIX + this.callTracer.methodName + ".streaming.message_bytes", this.callTracer.histogramAllTags), optionalWireSize);
                }
            }
        }

        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            if (this.callTracer.streamingStats) {
                this.callTracer.responseMessageCount.incrementAndGet();
                if (optionalWireSize >= 0L) {
                    WavefrontClientInterceptor.this.wfGrpcReporter.updateHistogram(new MetricName(WavefrontClientInterceptor.RESPONSE_PREFIX + this.callTracer.methodName + ".streaming.message_bytes", this.callTracer.histogramAllTags), optionalWireSize);
                }
            }
        }
    }

    private class ClientCallTracer
    extends ClientStreamTracer.Factory {
        final String grpcService;
        final String methodName;
        final boolean streamingStats;
        final Span span;
        final AtomicBoolean streamClosed = new AtomicBoolean(false);
        @Nullable
        final AtomicLong requestMessageCount;
        @Nullable
        final AtomicLong responseMessageCount;
        final AtomicLong requestBytes = new AtomicLong(0L);
        final AtomicLong responseBytes = new AtomicLong(0L);
        final long startTime;
        final Map<String, String> allTags;
        final Map<String, String> overallAggregatedPerSourceTags;
        final Map<String, String> histogramAllTags;

        ClientCallTracer(String grpcService, String methodName, @Nullable boolean streamingStats, Span span) {
            this.grpcService = grpcService;
            this.methodName = methodName;
            this.streamingStats = streamingStats;
            this.span = span;
            this.startTime = System.currentTimeMillis();
            this.requestMessageCount = streamingStats ? new AtomicLong(0L) : null;
            this.responseMessageCount = streamingStats ? new AtomicLong(0L) : null;
            ImmutableMap.Builder tagsBuilder = ImmutableMap.builder().put((Object)"cluster", (Object)(WavefrontClientInterceptor.this.applicationTags.getCluster() == null ? "none" : WavefrontClientInterceptor.this.applicationTags.getCluster())).put((Object)"service", (Object)WavefrontClientInterceptor.this.applicationTags.getService()).put((Object)"shard", (Object)(WavefrontClientInterceptor.this.applicationTags.getShard() == null ? "none" : WavefrontClientInterceptor.this.applicationTags.getShard()));
            this.overallAggregatedPerSourceTags = tagsBuilder.build();
            this.allTags = tagsBuilder.put((Object)"grpc.service", (Object)grpcService).build();
            this.histogramAllTags = tagsBuilder.put((Object)"grpc.method", (Object)methodName).build();
            WavefrontClientInterceptor.this.getGaugeValue(new MetricName(WavefrontClientInterceptor.REQUEST_PREFIX + methodName + ".inflight", this.allTags)).incrementAndGet();
            WavefrontClientInterceptor.this.getGaugeValue(new MetricName(WavefrontClientInterceptor.CLIENT_TOTAL_INFLIGHT, this.overallAggregatedPerSourceTags)).incrementAndGet();
        }

        public ClientStreamTracer newClientStreamTracer(CallOptions callOptions, final Metadata headers) {
            if (this.span != null) {
                WavefrontClientInterceptor.this.tracer.inject(this.span.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMap(){

                    public void put(String key, String value) {
                        Metadata.Key headerKey = Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                        headers.put(headerKey, (Object)value);
                    }

                    public Iterator<Map.Entry<String, String>> iterator() {
                        throw new UnsupportedOperationException("TextMap should only be used with Tracer.inject()");
                    }
                });
            }
            return new ClientTracer(this);
        }

        public void callEnded(Status status) {
            if (this.streamClosed.getAndSet(true)) {
                return;
            }
            long rpcLatency = System.currentTimeMillis() - this.startTime;
            this.finishClientSpan(status);
            WavefrontClientInterceptor.this.getGaugeValue(new MetricName(WavefrontClientInterceptor.REQUEST_PREFIX + this.methodName + ".inflight", this.allTags)).decrementAndGet();
            WavefrontClientInterceptor.this.getGaugeValue(new MetricName(WavefrontClientInterceptor.CLIENT_TOTAL_INFLIGHT, this.overallAggregatedPerSourceTags)).decrementAndGet();
            Utils.reportLatency(WavefrontClientInterceptor.CLIENT_PREFIX, this.methodName, status, rpcLatency, this.histogramAllTags, this.allTags, WavefrontClientInterceptor.this.wfGrpcReporter);
            Utils.reportRpcRequestBytes(WavefrontClientInterceptor.CLIENT_PREFIX, this.methodName, this.requestBytes.get(), this.histogramAllTags, this.allTags, WavefrontClientInterceptor.this.wfGrpcReporter);
            Utils.reportRpcResponseBytes(WavefrontClientInterceptor.CLIENT_PREFIX, this.methodName, this.responseBytes.get(), this.histogramAllTags, this.allTags, WavefrontClientInterceptor.this.wfGrpcReporter);
            if (this.streamingStats) {
                Utils.reportRequestMessageCount(WavefrontClientInterceptor.CLIENT_PREFIX, this.methodName, this.requestMessageCount.get(), this.allTags, this.histogramAllTags, WavefrontClientInterceptor.this.wfGrpcReporter);
                Utils.reportResponseMessageCount(WavefrontClientInterceptor.CLIENT_PREFIX, this.methodName, this.responseMessageCount.get(), this.allTags, this.histogramAllTags, WavefrontClientInterceptor.this.wfGrpcReporter);
            }
            Utils.reportResponseAndErrorStats(WavefrontClientInterceptor.CLIENT_PREFIX, this.methodName, this.grpcService, status, WavefrontClientInterceptor.this.applicationTags, this.allTags, this.overallAggregatedPerSourceTags, WavefrontClientInterceptor.this.wfGrpcReporter);
        }

        private void finishClientSpan(Status status) {
            if (this.span != null) {
                this.span.setTag("grpc.status", status.getCode().toString());
                if (status.getCode() != Status.Code.OK) {
                    Tags.ERROR.set(this.span, Boolean.valueOf(true));
                }
                this.span.setTag("request.bytes", (Number)this.requestBytes.get());
                this.span.setTag("response.bytes", (Number)this.responseBytes.get());
                if (this.streamingStats) {
                    this.span.setTag("request.messages.count", (Number)this.requestMessageCount.get());
                    this.span.setTag("response.messages.count", (Number)this.responseMessageCount.get());
                }
                this.span.finish();
            }
        }
    }

    public static class Builder {
        private WavefrontGrpcReporter wfGrpcReporter;
        @Nullable
        private Tracer tracer;
        @Nullable
        private Function<String, String> spanNameOverride;
        private ApplicationTags applicationTags;
        boolean recordStreamingStats = false;

        public Builder(WavefrontGrpcReporter wfGrpcReporter, ApplicationTags applicationTags) {
            this.wfGrpcReporter = (WavefrontGrpcReporter)Preconditions.checkNotNull((Object)wfGrpcReporter, (Object)"invalid reporter");
            this.applicationTags = (ApplicationTags)Preconditions.checkNotNull((Object)applicationTags, (Object)"invalid app tags");
        }

        public Builder recordStreamingStats() {
            this.recordStreamingStats = true;
            return this;
        }

        public Builder withTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder spanNameOverride(Function<String, String> fullMethodNameTransform) {
            this.spanNameOverride = fullMethodNameTransform;
            return this;
        }

        public WavefrontClientInterceptor build() {
            return new WavefrontClientInterceptor(this.wfGrpcReporter, this.tracer, this.applicationTags, this.recordStreamingStats, this.spanNameOverride);
        }
    }
}

