/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.grpc;

import com.google.common.collect.ImmutableMap;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.grpc.reporter.WavefrontGrpcReporter;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Map;

final class Utils {
    private Utils() {
    }

    static String getServiceName(String fullMethodName) {
        return fullMethodName.substring(0, fullMethodName.lastIndexOf(47));
    }

    static boolean isStreamingMethod(MethodDescriptor.MethodType methodType) {
        return methodType == MethodDescriptor.MethodType.SERVER_STREAMING || methodType == MethodDescriptor.MethodType.CLIENT_STREAMING || methodType == MethodDescriptor.MethodType.BIDI_STREAMING;
    }

    static String getFriendlyMethodName(String fullMethodName) {
        return fullMethodName.replace("/", ".");
    }

    static void reportRequestMessageCount(String prefix, String methodName, long requestMessageCount, Map<String, String> allTags, Map<String, String> histogramTags, WavefrontGrpcReporter wfGrpcReporter) {
        wfGrpcReporter.updateHistogram(new MetricName(prefix + "request." + methodName + ".streaming.messages_per_rpc", histogramTags), requestMessageCount);
        wfGrpcReporter.incrementCounter(new MetricName(prefix + "request." + methodName + ".streaming.messages", allTags), requestMessageCount);
    }

    static void reportResponseMessageCount(String prefix, String methodName, long responseMessageCount, Map<String, String> allTags, Map<String, String> histogramTags, WavefrontGrpcReporter wfGrpcReporter) {
        wfGrpcReporter.updateHistogram(new MetricName(prefix + "response." + methodName + ".streaming.messages_per_rpc", histogramTags), responseMessageCount);
        wfGrpcReporter.incrementCounter(new MetricName(prefix + "response." + methodName + ".streaming.messages", allTags), responseMessageCount);
    }

    static void reportLatency(String prefix, String methodName, Status status, long rpcLatency, Map<String, String> histogramTags, Map<String, String> allTags, WavefrontGrpcReporter wfGrpcReporter) {
        String methodWithStatus = methodName + "." + status.getCode().toString();
        wfGrpcReporter.updateHistogram(new MetricName(prefix + "response." + methodWithStatus + ".latency", histogramTags), rpcLatency);
        wfGrpcReporter.incrementCounter(new MetricName(prefix + "response." + methodWithStatus + ".total_time", allTags), rpcLatency);
    }

    static void reportRpcRequestBytes(String prefix, String methodName, long requestBytes, Map<String, String> histogramTags, Map<String, String> allTags, WavefrontGrpcReporter wfGrpcReporter) {
        wfGrpcReporter.updateHistogram(new MetricName(prefix + "request." + methodName + ".bytes", histogramTags), requestBytes);
        wfGrpcReporter.incrementCounter(new MetricName(prefix + "request." + methodName + ".total_bytes", allTags), requestBytes);
    }

    static void reportRpcResponseBytes(String prefix, String methodName, long responseBytes, Map<String, String> tags, Map<String, String> allTags, WavefrontGrpcReporter wfGrpcReporter) {
        wfGrpcReporter.updateHistogram(new MetricName(prefix + "response." + methodName + ".bytes", tags), responseBytes);
        wfGrpcReporter.incrementCounter(new MetricName(prefix + "response." + methodName + ".total_bytes", allTags), responseBytes);
    }

    static void reportResponseAndErrorStats(String prefix, String methodName, String grpcService, Status status, ApplicationTags applicationTags, Map<String, String> allTags, Map<String, String> overallAggregatedPerSourceTags, WavefrontGrpcReporter wfGrpcReporter) {
        String methodWithStatus = methodName + "." + status.getCode().toString();
        ImmutableMap.Builder granularMetricsTags = ImmutableMap.builder().put((Object)"grpc.service", (Object)grpcService).put((Object)"source", (Object)"wavefront-provided");
        ImmutableMap aggergatedPerApplicationTags = granularMetricsTags.build();
        ImmutableMap aggregatedPerClutserTags = granularMetricsTags.put((Object)"cluster", (Object)(applicationTags.getCluster() == null ? "none" : applicationTags.getCluster())).build();
        ImmutableMap aggregatedPerServiceTags = granularMetricsTags.put((Object)"service", (Object)applicationTags.getService()).build();
        ImmutableMap aggregatedPerShardTags = granularMetricsTags.put((Object)"shard", (Object)(applicationTags.getShard() == null ? "none" : applicationTags.getShard())).build();
        wfGrpcReporter.incrementCounter(new MetricName(prefix + "response." + methodWithStatus + ".cumulative", allTags));
        wfGrpcReporter.incrementDeltaCounter(new MetricName(prefix + "response." + methodWithStatus + ".aggregated_per_shard", (Map)aggregatedPerShardTags));
        wfGrpcReporter.incrementDeltaCounter(new MetricName(prefix + "response." + methodWithStatus + ".aggregated_per_service", (Map)aggregatedPerServiceTags));
        wfGrpcReporter.incrementDeltaCounter(new MetricName(prefix + "response." + methodWithStatus + ".aggregated_per_cluster", (Map)aggregatedPerClutserTags));
        wfGrpcReporter.incrementDeltaCounter(new MetricName(prefix + "response." + methodWithStatus + ".aggregated_per_application", (Map)aggergatedPerApplicationTags));
        ImmutableMap.Builder overallTagsBuilder = ImmutableMap.builder().put((Object)"source", (Object)"wavefront-provided");
        ImmutableMap overallAggregatedPerApplicationTags = overallTagsBuilder.build();
        ImmutableMap overallAggregatedPerClusterTags = overallTagsBuilder.put((Object)"cluster", (Object)(applicationTags.getCluster() == null ? "none" : applicationTags.getCluster())).build();
        ImmutableMap overallAggregatedPerServiceTags = overallTagsBuilder.put((Object)"service", (Object)applicationTags.getService()).build();
        ImmutableMap overallAggregatedPerShardTags = overallTagsBuilder.put((Object)"shard", (Object)(applicationTags.getShard() == null ? "none" : applicationTags.getShard())).build();
        wfGrpcReporter.incrementCounter(new MetricName(prefix + "response.completed.aggregated_per_source", overallAggregatedPerSourceTags));
        wfGrpcReporter.incrementDeltaCounter(new MetricName(prefix + "response.completed.aggregated_per_shard", (Map)overallAggregatedPerShardTags));
        wfGrpcReporter.incrementDeltaCounter(new MetricName(prefix + "response.completed.aggregated_per_service", (Map)overallAggregatedPerServiceTags));
        wfGrpcReporter.incrementDeltaCounter(new MetricName(prefix + "response.completed.aggregated_per_cluster", (Map)overallAggregatedPerClusterTags));
        wfGrpcReporter.incrementDeltaCounter(new MetricName(prefix + "response.completed.aggregated_per_application", (Map)overallAggregatedPerApplicationTags));
        if (status.getCode() != Status.Code.OK) {
            wfGrpcReporter.incrementCounter(new MetricName(prefix + "response.errors.aggregated_per_source", overallAggregatedPerSourceTags));
            wfGrpcReporter.incrementDeltaCounter(new MetricName(prefix + "response.errors.aggregated_per_shard", (Map)overallAggregatedPerShardTags));
            wfGrpcReporter.incrementDeltaCounter(new MetricName(prefix + "response.errors.aggregated_per_service", (Map)overallAggregatedPerServiceTags));
            wfGrpcReporter.incrementDeltaCounter(new MetricName(prefix + "response.errors.aggregated_per_cluster", (Map)overallAggregatedPerClusterTags));
            wfGrpcReporter.incrementDeltaCounter(new MetricName(prefix + "response.errors.aggregated_per_application", (Map)overallAggregatedPerApplicationTags));
            wfGrpcReporter.incrementCounter(new MetricName(prefix + "response." + methodName + ".errors", allTags));
        }
    }
}

