/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SslSimpleBuilder {
    private static final Logger logger = LogManager.getLogger(SslSimpleBuilder.class);
    private File sslKeyFile;
    private File sslCertificateFile;
    private SslClientVerifyMode verifyMode = SslClientVerifyMode.FORCE_PEER;
    private long handshakeTimeoutMilliseconds = 10000L;
    public static final String[] DEFAULT_CIPHERS = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"};
    private String[] ciphers = DEFAULT_CIPHERS;
    private String[] protocols = new String[]{"TLSv1.2"};
    private String[] certificateAuthorities;
    private String passPhrase;

    public SslSimpleBuilder(String sslCertificateFilePath, String sslKeyFilePath, String pass) throws FileNotFoundException {
        this.sslCertificateFile = new File(sslCertificateFilePath);
        this.sslKeyFile = new File(sslKeyFilePath);
        this.passPhrase = pass;
        this.ciphers = DEFAULT_CIPHERS;
    }

    public SslSimpleBuilder setProtocols(String[] protocols) {
        this.protocols = protocols;
        return this;
    }

    public SslSimpleBuilder setCipherSuites(String[] ciphersSuite) throws IllegalArgumentException {
        for (String cipher : ciphersSuite) {
            if (!OpenSsl.isCipherSuiteAvailable((String)cipher)) {
                throw new IllegalArgumentException("Cipher `" + cipher + "` is not available");
            }
            logger.debug("Cipher is supported: " + cipher);
        }
        this.ciphers = ciphersSuite;
        return this;
    }

    public SslSimpleBuilder setCertificateAuthorities(String[] cert) {
        this.certificateAuthorities = cert;
        return this;
    }

    public SslSimpleBuilder setHandshakeTimeoutMilliseconds(int timeout) {
        this.handshakeTimeoutMilliseconds = timeout;
        return this;
    }

    public SslSimpleBuilder setVerifyMode(SslClientVerifyMode mode) {
        this.verifyMode = mode;
        return this;
    }

    public File getSslKeyFile() {
        return this.sslKeyFile;
    }

    public File getSslCertificateFile() {
        return this.sslCertificateFile;
    }

    public SslHandler build(ByteBufAllocator bufferAllocator) throws IOException, NoSuchAlgorithmException, CertificateException {
        SslContextBuilder builder = SslContextBuilder.forServer((File)this.sslCertificateFile, (File)this.sslKeyFile, (String)this.passPhrase);
        if (logger.isDebugEnabled()) {
            logger.debug("Available ciphers:" + Arrays.toString(OpenSsl.availableOpenSslCipherSuites().toArray()));
        }
        logger.debug("Ciphers:  " + Arrays.toString(this.ciphers));
        builder.ciphers(Arrays.asList(this.ciphers));
        if (this.requireClientAuth()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Certificate Authorities: " + Arrays.toString(this.certificateAuthorities));
            }
            builder.trustManager(this.loadCertificateCollection(this.certificateAuthorities));
        }
        SslContext context = builder.build();
        SslHandler sslHandler = context.newHandler(bufferAllocator);
        if (logger.isDebugEnabled()) {
            logger.debug("TLS: " + Arrays.toString(this.protocols));
        }
        SSLEngine engine = sslHandler.engine();
        engine.setEnabledProtocols(this.protocols);
        if (this.requireClientAuth()) {
            engine.setUseClientMode(false);
            if (this.verifyMode == SslClientVerifyMode.FORCE_PEER) {
                engine.setNeedClientAuth(true);
            } else if (this.verifyMode == SslClientVerifyMode.VERIFY_PEER) {
                engine.setWantClientAuth(true);
            }
        }
        sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeoutMilliseconds);
        return sslHandler;
    }

    private X509Certificate[] loadCertificateCollection(String[] certificates) throws IOException, CertificateException {
        logger.debug("Load certificates collection");
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList collections = new ArrayList();
        for (int i = 0; i < certificates.length; ++i) {
            String certificate = certificates[i];
            logger.debug("Loading certificates from file " + certificate);
            try (FileInputStream in = new FileInputStream(certificate);){
                List certificatesChains = (List)certificateFactory.generateCertificates(in);
                collections.addAll(certificatesChains);
                continue;
            }
        }
        return collections.toArray(new X509Certificate[collections.size()]);
    }

    private boolean requireClientAuth() {
        return this.certificateAuthorities != null;
    }

    private FileInputStream createFileInputStream(String filepath) throws FileNotFoundException {
        return new FileInputStream(filepath);
    }

    String[] getProtocols() {
        return (String[])this.protocols.clone();
    }

    public static enum SslClientVerifyMode {
        VERIFY_PEER,
        FORCE_PEER;

    }
}

