/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.logstash.beats.Message;

public class BatchIdentity {
    private final String timestampStr;
    private final int highestSequence;
    private final int size;
    @Nullable
    private final String logFile;
    @Nullable
    private final Integer logFileOffset;

    BatchIdentity(String timestampStr, int highestSequence, int size, @Nullable String logFile, @Nullable Integer logFileOffset) {
        this.timestampStr = timestampStr;
        this.highestSequence = highestSequence;
        this.size = size;
        this.logFile = logFile;
        this.logFileOffset = logFileOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchIdentity that = (BatchIdentity)o;
        return this.highestSequence == that.highestSequence && this.size == that.size && Objects.equals(this.timestampStr, that.timestampStr) && Objects.equals(this.logFile, that.logFile) && Objects.equals(this.logFileOffset, that.logFileOffset);
    }

    public int hashCode() {
        int result = this.timestampStr != null ? this.timestampStr.hashCode() : 0;
        result = 31 * result + this.highestSequence;
        result = 31 * result + this.size;
        result = 31 * result + (this.logFile != null ? this.logFile.hashCode() : 0);
        result = 31 * result + (this.logFileOffset != null ? this.logFileOffset.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BatchIdentity{timestampStr=" + this.timestampStr + ", highestSequence=" + this.highestSequence + ", size=" + this.size + ", logFile=" + this.logFile + ", logFileOffset=" + this.logFileOffset + "}";
    }

    @Nullable
    public static BatchIdentity valueFrom(Message message) {
        Map logFileData;
        Map logData;
        Map messageData = message.getData();
        if (!messageData.containsKey("@timestamp")) {
            return null;
        }
        String logFile = null;
        Integer logFileOffset = null;
        if (messageData.containsKey("log") && (logData = (Map)messageData.get("log")).containsKey("offset") && logData.containsKey("file") && (logFileData = (Map)logData.get("file")).containsKey("path")) {
            logFile = (String)logFileData.get("path");
            logFileOffset = (Integer)logData.get("offset");
        }
        return new BatchIdentity((String)messageData.get("@timestamp"), message.getBatch().getHighestSequence(), message.getBatch().size(), logFile, logFileOffset);
    }

    @Nullable
    public static String keyFrom(Message message) {
        Map hostData;
        Map agentData;
        Map messageData = message.getData();
        if (messageData.containsKey("agent") && (agentData = (Map)messageData.get("agent")).containsKey("id")) {
            return (String)agentData.get("id");
        }
        if (messageData.containsKey("host") && (hostData = (Map)messageData.get("host")).containsKey("name")) {
            return (String)hostData.get("name");
        }
        return null;
    }
}

