/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

public abstract class Utils {
    private static final ObjectMapper JSON_PARSER = new ObjectMapper();
    private static final ResourceBundle buildProps = ResourceBundle.getBundle("build");
    private static final List<Integer> UUID_SEGMENTS = ImmutableList.of((Object)8, (Object)4, (Object)4, (Object)4, (Object)12);
    private static final Logger log = Logger.getLogger(Utils.class.getCanonicalName());

    public static <T> Supplier<T> lazySupplier(final Supplier<T> supplier) {
        return new Supplier<T>(){
            private volatile T value = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (this.value == null) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.value == null) {
                            this.value = supplier.get();
                        }
                    }
                }
                return this.value;
            }
        };
    }

    public static String addHyphensToUuid(String uuid) {
        if (uuid.length() != 32) {
            return uuid;
        }
        StringBuilder result = new StringBuilder();
        int startOffset = 0;
        for (Integer segmentLength : UUID_SEGMENTS) {
            result.append(uuid, startOffset, startOffset + segmentLength);
            if (result.length() < 36) {
                result.append('-');
            }
            startOffset += segmentLength.intValue();
        }
        return result.toString();
    }

    @Nullable
    public static String convertToUuidString(@Nullable String id) {
        if (id == null || id.contains("-")) {
            return id;
        }
        return Utils.addHyphensToUuid(StringUtils.leftPad((String)id, (int)32, (char)'0'));
    }

    @Nonnull
    public static List<String> csvToList(@Nullable String inputString) {
        return inputString == null ? Collections.emptyList() : Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)inputString);
    }

    public static String getBuildVersion() {
        try {
            return buildProps.getString("build.version");
        }
        catch (MissingResourceException ex) {
            return "unknown";
        }
    }

    public static String getPackage() {
        try {
            return buildProps.getString("build.package");
        }
        catch (MissingResourceException ex) {
            return "unknown";
        }
    }

    public static String getJavaVersion() {
        return System.getProperty("java.runtime.name", "(unknown runtime)") + " (" + System.getProperty("java.vendor", "") + ") " + System.getProperty("java.version", "(unknown version)");
    }

    public static String getLocalHostName() {
        for (String env : Arrays.asList("COMPUTERNAME", "HOSTNAME", "PROXY_HOSTNAME")) {
            String hostname = System.getenv(env);
            if (!StringUtils.isNotBlank((String)hostname)) continue;
            log.info("Hostname: '" + hostname + "' (detected using '" + env + "' env variable)");
            return hostname;
        }
        try {
            String hostname = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("hostname").getInputStream())).readLine();
            if (StringUtils.isNotBlank((String)hostname)) {
                log.info("Hostname: '" + hostname + "' (detected using 'hostname' command)");
                return hostname;
            }
        }
        catch (IOException e) {
            log.fine("Error running 'hostname' command. " + e.getMessage());
        }
        InetAddress localAddress = null;
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            block5: while (nics.hasMoreElements()) {
                NetworkInterface network = nics.nextElement();
                if (!network.isUp() || network.isLoopback()) continue;
                Enumeration<InetAddress> addresses = network.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isMulticastAddress()) continue;
                    if (address instanceof Inet4Address) {
                        localAddress = address;
                        continue block5;
                    }
                    if (localAddress != null) continue;
                    localAddress = address;
                }
            }
        }
        catch (SocketException nics) {
            // empty catch block
        }
        if (localAddress != null) {
            String hostname = localAddress.getCanonicalHostName();
            log.info("Hostname: '" + hostname + "' (detected using network interfaces)");
            return hostname;
        }
        log.info("Hostname not detected, using 'localhost')");
        return "localhost";
    }

    public static boolean isWavefrontResponse(@Nonnull Response response) {
        try {
            Status res = (Status)JSON_PARSER.readValue((String)response.readEntity(String.class), Status.class);
            if (res.code == response.getStatus()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static <E extends Throwable> E throwAny(Throwable t) throws E {
        throw t;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Status {
        @JsonProperty
        String message;
        @JsonProperty
        int code;

        private Status() {
        }
    }
}

