/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.queueing;

import com.google.common.util.concurrent.RateLimiter;
import com.wavefront.agent.SharedMetricsRegistry;
import com.wavefront.agent.data.DataSubmissionTask;
import com.wavefront.agent.queueing.RetryTaskConverter;
import com.wavefront.agent.queueing.TaskConverter;
import com.wavefront.common.NamedThreadFactory;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class TaskSizeEstimator {
    private static final MetricsRegistry REGISTRY = SharedMetricsRegistry.getInstance();
    private final Histogram resultPostingSizes;
    private final Meter resultPostingMeter;
    private final ExecutorService resultPostingSizerExecutorService;
    private final TaskConverter<DataSubmissionTask> taskConverter;
    private final RateLimiter resultSizingRateLimier = RateLimiter.create((double)0.2);

    public TaskSizeEstimator(String handle) {
        this.resultPostingSizes = REGISTRY.newHistogram((MetricName)new TaggedMetricName("post-result", "result-size", new String[]{"port", handle}), true);
        this.resultPostingMeter = REGISTRY.newMeter((MetricName)new TaggedMetricName("post-result", "results", new String[]{"port", handle}), "results", TimeUnit.MINUTES);
        this.resultPostingSizerExecutorService = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("result-posting-sizer-" + handle));
        this.taskConverter = new RetryTaskConverter<DataSubmissionTask>(handle, TaskConverter.CompressionType.LZ4);
        Metrics.newGauge((MetricName)new TaggedMetricName("buffer", "fill-rate", new String[]{"port", handle}), (Gauge)new Gauge<Long>(){

            public Long value() {
                return TaskSizeEstimator.this.getBytesPerMinute();
            }
        });
    }

    public <T extends DataSubmissionTask<T>> void scheduleTaskForSizing(T task) {
        this.resultPostingMeter.mark();
        try {
            if (this.resultSizingRateLimier.tryAcquire()) {
                this.resultPostingSizerExecutorService.submit(this.getPostingSizerTask(task));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public Long getBytesPerMinute() {
        if (this.resultPostingSizes.count() < 50L) {
            return null;
        }
        if (this.resultPostingMeter.fifteenMinuteRate() == 0.0 || this.resultPostingSizes.mean() == 0.0) {
            return null;
        }
        return (long)(this.resultPostingSizes.mean() * this.resultPostingMeter.fifteenMinuteRate());
    }

    public void shutdown() {
        this.resultPostingSizerExecutorService.shutdown();
    }

    private <T extends DataSubmissionTask<T>> Runnable getPostingSizerTask(T task) {
        return () -> {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                this.taskConverter.serializeToStream(task, outputStream);
                this.resultPostingSizes.update(outputStream.size());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }
}

