/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.queueing;

import com.google.common.collect.ImmutableMap;
import com.wavefront.agent.data.DataSubmissionTask;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.data.ReportableEntityType;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;

public class InstrumentedTaskQueueDelegate<T extends DataSubmissionTask<T>>
implements TaskQueue<T> {
    private static final Logger log = Logger.getLogger(InstrumentedTaskQueueDelegate.class.getCanonicalName());
    private final TaskQueue<T> delegate;
    private volatile T head;
    private final String prefix;
    private final Map<String, String> tags;
    private final Counter tasksAddedCounter;
    private final Counter itemsAddedCounter;
    private final Counter tasksRemovedCounter;
    private final Counter itemsRemovedCounter;

    public InstrumentedTaskQueueDelegate(TaskQueue<T> delegate, @Nullable String metricPrefix, @Nullable Map<String, String> metricTags, @Nullable ReportableEntityType entityType) {
        this.delegate = delegate;
        String entityName = entityType == null ? "points" : entityType.toString();
        this.prefix = (String)ObjectUtils.firstNonNull((Object[])new String[]{metricPrefix, "buffer"});
        this.tags = metricTags == null ? ImmutableMap.of() : metricTags;
        this.tasksAddedCounter = Metrics.newCounter((MetricName)new TaggedMetricName(this.prefix, "task-added", this.tags));
        this.itemsAddedCounter = Metrics.newCounter((MetricName)new TaggedMetricName(this.prefix, entityName + "-added", this.tags));
        this.tasksRemovedCounter = Metrics.newCounter((MetricName)new TaggedMetricName(this.prefix, "task-removed", this.tags));
        this.itemsRemovedCounter = Metrics.newCounter((MetricName)new TaggedMetricName(this.prefix, entityName + "-removed", this.tags));
    }

    @Override
    public T peek() {
        try {
            if (this.head != null) {
                return this.head;
            }
            this.head = this.delegate.peek();
            return this.head;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                Metrics.newCounter((MetricName)new TaggedMetricName(this.prefix, "failures", this.tags)).inc();
                log.severe("I/O error retrieving data from the queue: " + e.getMessage());
                this.head = null;
                return null;
            }
            throw e;
        }
    }

    @Override
    public void add(@Nonnull T t) throws IOException {
        this.delegate.add(t);
        this.tasksAddedCounter.inc();
        this.itemsAddedCounter.inc((long)t.weight());
    }

    @Override
    public void clear() {
        try {
            this.head = null;
            this.delegate.clear();
        }
        catch (IOException e) {
            Metrics.newCounter((MetricName)new TaggedMetricName(this.prefix, "failures", this.tags)).inc();
            log.severe("I/O error clearing queue: " + e.getMessage());
        }
    }

    @Override
    public void remove() {
        try {
            T t = this.head == null ? this.delegate.peek() : this.head;
            long size = t == null ? 0L : (long)t.weight();
            this.delegate.remove();
            this.head = null;
            this.tasksRemovedCounter.inc();
            this.itemsRemovedCounter.inc(size);
        }
        catch (IOException e) {
            Metrics.newCounter((MetricName)new TaggedMetricName(this.prefix, "failures", this.tags)).inc();
            log.severe("I/O error removing task from the queue: " + e.getMessage());
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    @Nullable
    public Long weight() {
        return this.delegate.weight();
    }

    @Override
    @Nullable
    public Long getAvailableBytes() {
        return this.delegate.getAvailableBytes();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }
}

