/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.queueing;

import com.wavefront.agent.queueing.QueueFile;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcurrentQueueFile
implements QueueFile {
    private final QueueFile delegate;
    private final ReentrantLock lock = new ReentrantLock(true);

    public ConcurrentQueueFile(QueueFile delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(byte[] data, int offset, int count) throws IOException {
        this.lock.lock();
        try {
            this.delegate.add(data, offset, count);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() throws IOException {
        this.lock.lock();
        try {
            this.delegate.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Nullable
    public byte[] peek() throws IOException {
        this.lock.lock();
        try {
            byte[] byArray = this.delegate.peek();
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remove() throws IOException {
        this.lock.lock();
        try {
            this.delegate.remove();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public long storageBytes() {
        return this.delegate.storageBytes();
    }

    @Override
    public long usedBytes() {
        return this.delegate.usedBytes();
    }

    @Override
    public long availableBytes() {
        return this.delegate.availableBytes();
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.delegate.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @NotNull
    public Iterator<byte[]> iterator() {
        return this.delegate.iterator();
    }
}

