/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.sdk.common.Utils;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanSanitizeTransformer
implements Function<Span, Span> {
    private final PreprocessorRuleMetrics ruleMetrics;

    public SpanSanitizeTransformer(PreprocessorRuleMetrics ruleMetrics) {
        this.ruleMetrics = ruleMetrics;
    }

    public Span apply(@Nullable Span span) {
        String source;
        if (span == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        boolean ruleApplied = false;
        String name = span.getName();
        if (name != null) {
            span.setName(this.sanitizeValue(name).replace('*', '-'));
            if (!span.getName().equals(name)) {
                ruleApplied = true;
            }
        }
        if ((source = span.getSource()) != null) {
            span.setSource(Utils.sanitizeWithoutQuotes((String)source));
            if (!span.getSource().equals(source)) {
                ruleApplied = true;
            }
        }
        if (span.getAnnotations() != null) {
            for (Annotation a : span.getAnnotations()) {
                String value;
                String key = a.getKey();
                if (key != null) {
                    a.setKey(Utils.sanitizeWithoutQuotes((String)key));
                    if (!a.getKey().equals(key)) {
                        ruleApplied = true;
                    }
                }
                if ((value = a.getValue()) == null) continue;
                a.setValue(this.sanitizeValue(value));
                if (a.getValue().equals(value)) continue;
                ruleApplied = true;
            }
        }
        if (ruleApplied) {
            this.ruleMetrics.incrementRuleAppliedCounter();
        }
        this.ruleMetrics.ruleEnd(startNanos);
        return span;
    }

    private String sanitizeValue(String s) {
        return s.trim().replaceAll("\\n", "\\\\n");
    }
}

