/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanRenameAnnotationTransformer
implements Function<Span, Span> {
    private final String key;
    private final String newKey;
    @Nullable
    private final Pattern compiledPattern;
    private final boolean firstMatchOnly;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<Span> v2Predicate;

    public SpanRenameAnnotationTransformer(String key, String newKey, @Nullable String patternMatch, boolean firstMatchOnly, @Nullable Predicate<Span> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"[key] can't be null");
        this.newKey = (String)Preconditions.checkNotNull((Object)newKey, (Object)"[newkey] can't be null");
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"[key] can't be blank");
        Preconditions.checkArgument((!newKey.isEmpty() ? 1 : 0) != 0, (Object)"[newkey] can't be blank");
        this.compiledPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.firstMatchOnly = firstMatchOnly;
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Span apply(@Nullable Span span) {
        if (span == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(span)) {
                Span span2 = span;
                return span2;
            }
            Stream<Annotation> stream = span.getAnnotations().stream().filter(a -> a.getKey().equals(this.key) && (this.compiledPattern == null || this.compiledPattern.matcher(a.getValue()).matches()));
            if (this.firstMatchOnly) {
                stream.findFirst().ifPresent(value -> {
                    value.setKey(this.newKey);
                    this.ruleMetrics.incrementRuleAppliedCounter();
                });
            } else {
                List<Annotation> annotations = stream.collect(Collectors.toList());
                annotations.forEach(a -> a.setKey(this.newKey));
                if (!annotations.isEmpty()) {
                    this.ruleMetrics.incrementRuleAppliedCounter();
                }
            }
            Span span3 = span;
            return span3;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

