/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.predicates.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanExtractAnnotationTransformer
implements Function<Span, Span> {
    protected final String key;
    protected final String input;
    protected final String patternReplace;
    protected final Pattern compiledSearchPattern;
    @Nullable
    protected final Pattern compiledMatchPattern;
    @Nullable
    protected final String patternReplaceInput;
    protected final boolean firstMatchOnly;
    protected final PreprocessorRuleMetrics ruleMetrics;
    protected final Predicate<Span> v2Predicate;

    public SpanExtractAnnotationTransformer(String key, String input, String patternSearch, String patternReplace, @Nullable String replaceInput, @Nullable String patternMatch, boolean firstMatchOnly, @Nullable Predicate<Span> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"[key] can't be null");
        this.input = (String)Preconditions.checkNotNull((Object)input, (Object)"[input] can't be null");
        this.compiledSearchPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)patternSearch, (Object)"[search] can't be null"));
        this.patternReplace = (String)Preconditions.checkNotNull((Object)patternReplace, (Object)"[replace] can't be null");
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"[key] can't be blank");
        Preconditions.checkArgument((!input.isEmpty() ? 1 : 0) != 0, (Object)"[input] can't be blank");
        Preconditions.checkArgument((!patternSearch.isEmpty() ? 1 : 0) != 0, (Object)"[search] can't be blank");
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        this.patternReplaceInput = replaceInput;
        this.firstMatchOnly = firstMatchOnly;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    protected boolean extractAnnotation(@Nonnull Span span, String extractFrom, List<Annotation> annotationBuffer) {
        if (extractFrom == null || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(extractFrom).matches()) {
            return false;
        }
        Matcher patternMatcher = this.compiledSearchPattern.matcher(extractFrom);
        if (!patternMatcher.find()) {
            return false;
        }
        String value = patternMatcher.replaceAll(Util.expandPlaceholders((String)this.patternReplace, (Span)span));
        if (!value.isEmpty()) {
            annotationBuffer.add(new Annotation(this.key, value));
            this.ruleMetrics.incrementRuleAppliedCounter();
        }
        return true;
    }

    protected void internalApply(@Nonnull Span span) {
        ArrayList<Annotation> buffer = new ArrayList<Annotation>();
        block4 : switch (this.input) {
            case "spanName": {
                if (!this.extractAnnotation(span, span.getName(), buffer) || this.patternReplaceInput == null) break;
                span.setName(this.compiledSearchPattern.matcher(span.getName()).replaceAll(Util.expandPlaceholders((String)this.patternReplaceInput, (Span)span)));
                break;
            }
            case "sourceName": {
                if (!this.extractAnnotation(span, span.getSource(), buffer) || this.patternReplaceInput == null) break;
                span.setSource(this.compiledSearchPattern.matcher(span.getSource()).replaceAll(Util.expandPlaceholders((String)this.patternReplaceInput, (Span)span)));
                break;
            }
            default: {
                for (Annotation a : span.getAnnotations()) {
                    if (!a.getKey().equals(this.input) || !this.extractAnnotation(span, a.getValue(), buffer)) continue;
                    if (this.patternReplaceInput != null) {
                        a.setValue(this.compiledSearchPattern.matcher(a.getValue()).replaceAll(Util.expandPlaceholders((String)this.patternReplaceInput, (Span)span)));
                    }
                    if (!this.firstMatchOnly) continue;
                    break block4;
                }
            }
        }
        span.getAnnotations().addAll(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Span apply(@Nullable Span span) {
        if (span == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(span)) {
                Span span2 = span;
                return span2;
            }
            this.internalApply(span);
            Span span3 = span;
            return span3;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

