/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import wavefront.report.Span;

public class SpanAllowAnnotationTransformer
implements Function<Span, Span> {
    private static final Set<String> SYSTEM_TAGS = ImmutableSet.of((Object)"service", (Object)"application", (Object)"cluster", (Object)"shard");
    private final Map<String, Pattern> allowedKeys;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<Span> v2Predicate;

    SpanAllowAnnotationTransformer(Map<String, String> keys, @Nullable Predicate<Span> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.allowedKeys = new HashMap<String, Pattern>(keys.size() + SYSTEM_TAGS.size());
        SYSTEM_TAGS.forEach(x -> this.allowedKeys.put((String)x, (Pattern)null));
        keys.forEach((k, v) -> this.allowedKeys.put((String)k, v == null ? null : Pattern.compile(v)));
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Span apply(@Nullable Span span) {
        if (span == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(span)) {
                Span span2 = span;
                return span2;
            }
            List annotations = span.getAnnotations().stream().filter(x -> this.allowedKeys.containsKey(x.getKey())).filter(x -> SpanAllowAnnotationTransformer.isPatternNullOrMatches(this.allowedKeys.get(x.getKey()), x.getValue())).collect(Collectors.toList());
            if (annotations.size() < span.getAnnotations().size()) {
                span.setAnnotations(annotations);
                this.ruleMetrics.incrementRuleAppliedCounter();
            }
            Span span3 = span;
            return span3;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }

    private static boolean isPatternNullOrMatches(@Nullable Pattern pattern, String string) {
        return pattern == null || pattern.matcher(string).matches();
    }

    public static SpanAllowAnnotationTransformer create(Map<String, Object> ruleMap, @Nullable Predicate<Span> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        Object keys = ruleMap.get("allow");
        if (keys instanceof Map) {
            return new SpanAllowAnnotationTransformer((Map)keys, v2Predicate, ruleMetrics);
        }
        if (keys instanceof List) {
            HashMap<String, String> map = new HashMap<String, String>();
            ((List)keys).forEach(x -> map.put((String)x, (String)null));
            return new SpanAllowAnnotationTransformer(map, null, ruleMetrics);
        }
        throw new IllegalArgumentException("[allow] is not a list or a map");
    }
}

