/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.predicates.Util;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class ReportPointReplaceRegexTransformer
implements Function<ReportPoint, ReportPoint> {
    private final String patternReplace;
    private final String scope;
    private final Pattern compiledSearchPattern;
    private final Integer maxIterations;
    @Nullable
    private final Pattern compiledMatchPattern;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<ReportPoint> v2Predicate;

    public ReportPointReplaceRegexTransformer(String scope, String patternSearch, String patternReplace, @Nullable String patternMatch, @Nullable Integer maxIterations, @Nullable Predicate<ReportPoint> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.compiledSearchPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)patternSearch, (Object)"[search] can't be null"));
        Preconditions.checkArgument((!patternSearch.isEmpty() ? 1 : 0) != 0, (Object)"[search] can't be blank");
        this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"[scope] can't be null");
        Preconditions.checkArgument((!scope.isEmpty() ? 1 : 0) != 0, (Object)"[scope] can't be blank");
        this.patternReplace = (String)Preconditions.checkNotNull((Object)patternReplace, (Object)"[replace] can't be null");
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        this.maxIterations = maxIterations != null ? maxIterations : 1;
        Preconditions.checkArgument((this.maxIterations > 0 ? 1 : 0) != 0, (Object)"[iterations] must be > 0");
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    private String replaceString(@Nonnull ReportPoint reportPoint, String content) {
        Matcher patternMatcher = this.compiledSearchPattern.matcher(content);
        if (!patternMatcher.find()) {
            return content;
        }
        this.ruleMetrics.incrementRuleAppliedCounter();
        String replacement = Util.expandPlaceholders((String)this.patternReplace, (ReportPoint)reportPoint);
        for (int currentIteration = 0; currentIteration < this.maxIterations && (patternMatcher = this.compiledSearchPattern.matcher(content = patternMatcher.replaceAll(replacement))).find(); ++currentIteration) {
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportPoint apply(@Nullable ReportPoint reportPoint) {
        if (reportPoint == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportPoint)) {
                ReportPoint reportPoint2 = reportPoint;
                return reportPoint2;
            }
            switch (this.scope) {
                case "metricName": {
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(reportPoint.getMetric()).matches()) break;
                    reportPoint.setMetric(this.replaceString(reportPoint, reportPoint.getMetric()));
                    break;
                }
                case "sourceName": {
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(reportPoint.getHost()).matches()) break;
                    reportPoint.setHost(this.replaceString(reportPoint, reportPoint.getHost()));
                    break;
                }
                default: {
                    String tagValue;
                    if (reportPoint.getAnnotations() == null || (tagValue = (String)reportPoint.getAnnotations().get(this.scope)) == null || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(tagValue).matches()) break;
                    reportPoint.getAnnotations().put(this.scope, this.replaceString(reportPoint, tagValue));
                }
            }
            String string = reportPoint;
            return string;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

