/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.LengthLimitActionType;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.agent.preprocessor.PreprocessorUtil;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class ReportPointLimitLengthTransformer
implements Function<ReportPoint, ReportPoint> {
    private final String scope;
    private final int maxLength;
    private final LengthLimitActionType actionSubtype;
    @Nullable
    private final Pattern compiledMatchPattern;
    private final Predicate<ReportPoint> v2Predicate;
    private final PreprocessorRuleMetrics ruleMetrics;

    public ReportPointLimitLengthTransformer(@Nonnull String scope, int maxLength, @Nonnull LengthLimitActionType actionSubtype, @Nullable String patternMatch, @Nullable Predicate<ReportPoint> v2Predicate, @Nonnull PreprocessorRuleMetrics ruleMetrics) {
        this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"[scope] can't be null");
        Preconditions.checkArgument((!scope.isEmpty() ? 1 : 0) != 0, (Object)"[scope] can't be blank");
        if (actionSubtype == LengthLimitActionType.DROP && (scope.equals("metricName") || scope.equals("sourceName"))) {
            throw new IllegalArgumentException("'drop' action type can't be used in metricName and sourceName scope!");
        }
        if (actionSubtype == LengthLimitActionType.TRUNCATE_WITH_ELLIPSIS && maxLength < 3) {
            throw new IllegalArgumentException("'maxLength' must be at least 3 for 'truncateWithEllipsis' action type!");
        }
        Preconditions.checkArgument((maxLength > 0 ? 1 : 0) != 0, (Object)"[maxLength] needs to be > 0!");
        this.maxLength = maxLength;
        this.actionSubtype = actionSubtype;
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportPoint apply(@Nullable ReportPoint reportPoint) {
        if (reportPoint == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportPoint)) {
                ReportPoint reportPoint2 = reportPoint;
                return reportPoint2;
            }
            switch (this.scope) {
                case "metricName": {
                    if (reportPoint.getMetric().length() <= this.maxLength || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(reportPoint.getMetric()).matches()) break;
                    reportPoint.setMetric(PreprocessorUtil.truncate(reportPoint.getMetric(), this.maxLength, this.actionSubtype));
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    break;
                }
                case "sourceName": {
                    if (reportPoint.getHost().length() <= this.maxLength || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(reportPoint.getHost()).matches()) break;
                    reportPoint.setHost(PreprocessorUtil.truncate(reportPoint.getHost(), this.maxLength, this.actionSubtype));
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    break;
                }
                default: {
                    String tagValue;
                    if (reportPoint.getAnnotations() == null || (tagValue = (String)reportPoint.getAnnotations().get(this.scope)) == null || tagValue.length() <= this.maxLength) break;
                    if (this.actionSubtype == LengthLimitActionType.DROP) {
                        reportPoint.getAnnotations().remove(this.scope);
                        this.ruleMetrics.incrementRuleAppliedCounter();
                        break;
                    }
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(tagValue).matches()) break;
                    reportPoint.getAnnotations().put(this.scope, PreprocessorUtil.truncate(tagValue, this.maxLength, this.actionSubtype));
                    this.ruleMetrics.incrementRuleAppliedCounter();
                }
            }
            String string = reportPoint;
            return string;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

