/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class ReportPointDropTagTransformer
implements Function<ReportPoint, ReportPoint> {
    @Nonnull
    private final Pattern compiledTagPattern;
    @Nullable
    private final Pattern compiledValuePattern;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<ReportPoint> v2Predicate;

    public ReportPointDropTagTransformer(String tag, @Nullable String patternMatch, @Nullable Predicate<ReportPoint> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.compiledTagPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)tag, (Object)"[tag] can't be null"));
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0, (Object)"[tag] can't be blank");
        this.compiledValuePattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportPoint apply(@Nullable ReportPoint reportPoint) {
        if (reportPoint == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportPoint)) {
                ReportPoint reportPoint2 = reportPoint;
                return reportPoint2;
            }
            Iterator iterator = reportPoint.getAnnotations().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!this.compiledTagPattern.matcher((CharSequence)entry.getKey()).matches() || this.compiledValuePattern != null && !this.compiledValuePattern.matcher((CharSequence)entry.getValue()).matches()) continue;
                iterator.remove();
                this.ruleMetrics.incrementRuleAppliedCounter();
            }
            ReportPoint reportPoint3 = reportPoint;
            return reportPoint3;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

