/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.predicates.Util;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class ReportPointAddTagTransformer
implements Function<ReportPoint, ReportPoint> {
    protected final String tag;
    protected final String value;
    protected final PreprocessorRuleMetrics ruleMetrics;
    protected final Predicate<ReportPoint> v2Predicate;

    public ReportPointAddTagTransformer(String tag, String value, @Nullable Predicate<ReportPoint> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.tag = (String)Preconditions.checkNotNull((Object)tag, (Object)"[tag] can't be null");
        this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"[value] can't be null");
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0, (Object)"[tag] can't be blank");
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"[value] can't be blank");
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportPoint apply(@Nullable ReportPoint reportPoint) {
        if (reportPoint == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportPoint)) {
                ReportPoint reportPoint2 = reportPoint;
                return reportPoint2;
            }
            reportPoint.getAnnotations().put(this.tag, Util.expandPlaceholders((String)this.value, (ReportPoint)reportPoint));
            this.ruleMetrics.incrementRuleAppliedCounter();
            ReportPoint reportPoint3 = reportPoint;
            return reportPoint3;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

