/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.predicates.Util;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.ReportLog;

public class ReportLogReplaceRegexTransformer
implements Function<ReportLog, ReportLog> {
    private final String patternReplace;
    private final String scope;
    private final Pattern compiledSearchPattern;
    private final Integer maxIterations;
    @Nullable
    private final Pattern compiledMatchPattern;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<ReportLog> v2Predicate;

    public ReportLogReplaceRegexTransformer(String scope, String patternSearch, String patternReplace, @Nullable String patternMatch, @Nullable Integer maxIterations, @Nullable Predicate<ReportLog> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.compiledSearchPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)patternSearch, (Object)"[search] can't be null"));
        Preconditions.checkArgument((!patternSearch.isEmpty() ? 1 : 0) != 0, (Object)"[search] can't be blank");
        this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"[scope] can't be null");
        Preconditions.checkArgument((!scope.isEmpty() ? 1 : 0) != 0, (Object)"[scope] can't be blank");
        this.patternReplace = (String)Preconditions.checkNotNull((Object)patternReplace, (Object)"[replace] can't be null");
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        this.maxIterations = maxIterations != null ? maxIterations : 1;
        Preconditions.checkArgument((this.maxIterations > 0 ? 1 : 0) != 0, (Object)"[iterations] must be > 0");
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    private String replaceString(@Nonnull ReportLog reportLog, String content) {
        Matcher patternMatcher = this.compiledSearchPattern.matcher(content);
        if (!patternMatcher.find()) {
            return content;
        }
        this.ruleMetrics.incrementRuleAppliedCounter();
        String replacement = Util.expandPlaceholders((String)this.patternReplace, (ReportLog)reportLog);
        for (int currentIteration = 0; currentIteration < this.maxIterations && (patternMatcher = this.compiledSearchPattern.matcher(content = patternMatcher.replaceAll(replacement))).find(); ++currentIteration) {
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportLog apply(@Nullable ReportLog reportLog) {
        if (reportLog == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportLog)) {
                ReportLog reportLog2 = reportLog;
                return reportLog2;
            }
            block6 : switch (this.scope) {
                case "message": {
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(reportLog.getMessage()).matches()) break;
                    reportLog.setMessage(this.replaceString(reportLog, reportLog.getMessage()));
                    break;
                }
                case "sourceName": {
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(reportLog.getHost()).matches()) break;
                    reportLog.setHost(this.replaceString(reportLog, reportLog.getHost()));
                    break;
                }
                default: {
                    for (Annotation tagKV : reportLog.getAnnotations()) {
                        String newValue;
                        if (!tagKV.getKey().equals(this.scope) || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(tagKV.getValue()).matches() || (newValue = this.replaceString(reportLog, tagKV.getValue())).equals(tagKV.getValue())) continue;
                        tagKV.setValue(newValue);
                        break block6;
                    }
                }
            }
            String string = reportLog;
            return string;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

