/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.ReportLog;

public class ReportLogForceLowercaseTransformer
implements Function<ReportLog, ReportLog> {
    private final String scope;
    @Nullable
    private final Pattern compiledMatchPattern;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<ReportLog> v2Predicate;

    public ReportLogForceLowercaseTransformer(String scope, @Nullable String patternMatch, @Nullable Predicate<ReportLog> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"[scope] can't be null");
        Preconditions.checkArgument((!scope.isEmpty() ? 1 : 0) != 0, (Object)"[scope] can't be blank");
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportLog apply(@Nullable ReportLog reportLog) {
        if (reportLog == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportLog)) {
                ReportLog reportLog2 = reportLog;
                return reportLog2;
            }
            switch (this.scope) {
                case "message": {
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(reportLog.getMessage()).matches()) break;
                    reportLog.setMessage(reportLog.getMessage().toLowerCase());
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    break;
                }
                case "sourceName": {
                    if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(reportLog.getHost()).matches()) break;
                    reportLog.setHost(reportLog.getHost().toLowerCase());
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    break;
                }
                default: {
                    for (Annotation logTagKV : reportLog.getAnnotations()) {
                        if (!logTagKV.getKey().equals(this.scope) || this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(logTagKV.getValue()).matches()) continue;
                        logTagKV.setValue(logTagKV.getValue().toLowerCase());
                        this.ruleMetrics.incrementRuleAppliedCounter();
                    }
                }
            }
            String string = reportLog;
            return string;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

