/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.ReportLog;

public class ReportLogDropTagTransformer
implements Function<ReportLog, ReportLog> {
    @Nonnull
    private final Pattern compiledTagPattern;
    @Nullable
    private final Pattern compiledValuePattern;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<ReportLog> v2Predicate;

    public ReportLogDropTagTransformer(String tag, @Nullable String patternMatch, @Nullable Predicate<ReportLog> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.compiledTagPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)tag, (Object)"[tag] can't be null"));
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0, (Object)"[tag] can't be blank");
        this.compiledValuePattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportLog apply(@Nullable ReportLog reportlog) {
        if (reportlog == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportlog)) {
                ReportLog reportLog = reportlog;
                return reportLog;
            }
            ArrayList annotations = new ArrayList(reportlog.getAnnotations());
            Iterator iterator = annotations.iterator();
            boolean changed = false;
            while (iterator.hasNext()) {
                Annotation entry = (Annotation)iterator.next();
                if (!this.compiledTagPattern.matcher(entry.getKey()).matches() || this.compiledValuePattern != null && !this.compiledValuePattern.matcher(entry.getValue()).matches()) continue;
                changed = true;
                iterator.remove();
                this.ruleMetrics.incrementRuleAppliedCounter();
            }
            if (changed) {
                reportlog.setAnnotations(annotations);
            }
            ReportLog reportLog = reportlog;
            return reportLog;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

