/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.collect.ImmutableList;
import com.wavefront.agent.preprocessor.AnnotatedPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Preprocessor<T> {
    private final List<Function<T, T>> transformers;
    private final List<AnnotatedPredicate<T>> filters;

    public Preprocessor() {
        this(new ArrayList<Function<T, T>>(), new ArrayList<AnnotatedPredicate<T>>());
    }

    public Preprocessor(List<Function<T, T>> transformers, List<AnnotatedPredicate<T>> filters) {
        this.transformers = transformers;
        this.filters = filters;
    }

    public T transform(@Nonnull T item) {
        for (Function<T, T> func : this.transformers) {
            item = func.apply(item);
        }
        return item;
    }

    public boolean filter(@Nonnull T item) {
        return this.filter(item, null);
    }

    public boolean filter(@Nonnull T item, @Nullable String[] messageHolder) {
        if (messageHolder != null) {
            messageHolder[0] = null;
        }
        for (AnnotatedPredicate<T> predicate : this.filters) {
            if (predicate.test(item, messageHolder)) continue;
            return false;
        }
        return true;
    }

    public List<AnnotatedPredicate<T>> getFilters() {
        return ImmutableList.copyOf(this.filters);
    }

    public List<Function<T, T>> getTransformers() {
        return ImmutableList.copyOf(this.transformers);
    }

    public Preprocessor<T> merge(Preprocessor<T> other) {
        Preprocessor<T> result = new Preprocessor<T>();
        this.getTransformers().forEach(result::addTransformer);
        this.getFilters().forEach(result::addFilter);
        other.getTransformers().forEach(result::addTransformer);
        other.getFilters().forEach(result::addFilter);
        return result;
    }

    public void addTransformer(Function<T, T> transformer) {
        this.transformers.add(transformer);
    }

    public void addFilter(AnnotatedPredicate<T> filter) {
        this.filters.add(filter);
    }

    public void addTransformer(int index, Function<T, T> transformer) {
        this.transformers.add(index, transformer);
    }

    public void addFilter(int index, AnnotatedPredicate<T> filter) {
        this.filters.add(index, filter);
    }
}

