/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class LineBasedReplaceRegexTransformer
implements Function<String, String> {
    private final String patternReplace;
    private final Pattern compiledSearchPattern;
    private final Integer maxIterations;
    @Nullable
    private final Pattern compiledMatchPattern;
    private final PreprocessorRuleMetrics ruleMetrics;

    public LineBasedReplaceRegexTransformer(String patternSearch, String patternReplace, @Nullable String patternMatch, @Nullable Integer maxIterations, PreprocessorRuleMetrics ruleMetrics) {
        this.compiledSearchPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)patternSearch, (Object)"[search] can't be null"));
        Preconditions.checkArgument((!patternSearch.isEmpty() ? 1 : 0) != 0, (Object)"[search] can't be blank");
        this.compiledMatchPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        this.patternReplace = (String)Preconditions.checkNotNull((Object)patternReplace, (Object)"[replace] can't be null");
        this.maxIterations = maxIterations != null ? maxIterations : 1;
        Preconditions.checkArgument((this.maxIterations > 0 ? 1 : 0) != 0, (Object)"[iterations] must be > 0");
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String apply(String pointLine) {
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (this.compiledMatchPattern != null && !this.compiledMatchPattern.matcher(pointLine).matches()) {
                String string = pointLine;
                return string;
            }
            Matcher patternMatcher = this.compiledSearchPattern.matcher(pointLine);
            if (!patternMatcher.find()) {
                String string = pointLine;
                return string;
            }
            this.ruleMetrics.incrementRuleAppliedCounter();
            int currentIteration = 0;
            do {
                pointLine = patternMatcher.replaceAll(this.patternReplace);
            } while (++currentIteration < this.maxIterations && (patternMatcher = this.compiledSearchPattern.matcher(pointLine)).find());
            String string = pointLine;
            return string;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

