/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.AnnotatedPredicate;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class LineBasedAllowFilter
implements AnnotatedPredicate<String> {
    private final Pattern compiledPattern;
    private final PreprocessorRuleMetrics ruleMetrics;

    public LineBasedAllowFilter(String patternMatch, PreprocessorRuleMetrics ruleMetrics) {
        this.compiledPattern = Pattern.compile((String)Preconditions.checkNotNull((Object)patternMatch, (Object)"[match] can't be null"));
        Preconditions.checkArgument((!patternMatch.isEmpty() ? 1 : 0) != 0, (Object)"[match] can't be blank");
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(String pointLine, @Nullable String[] messageHolder) {
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.compiledPattern.matcher(pointLine).matches()) {
                this.ruleMetrics.incrementRuleAppliedCounter();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

