/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.wavefront.agent.InteractiveTester;
import com.wavefront.agent.formatter.DataFormat;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.listeners.WavefrontPortUnificationHandler;
import com.wavefront.agent.listeners.tracing.SpanUtils;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.ingester.Decoder;
import com.wavefront.ingester.HistogramDecoder;
import com.wavefront.ingester.ReportPointDecoder;
import com.wavefront.ingester.ReportPointDecoderWrapper;
import com.wavefront.ingester.ReportPointSerializer;
import com.wavefront.ingester.ReportableEntityDecoder;
import com.wavefront.ingester.SpanDecoder;
import com.wavefront.ingester.SpanSerializer;
import java.util.List;
import java.util.Scanner;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;
import wavefront.report.Span;

public class InteractivePreprocessorTester
implements InteractiveTester {
    private static final SpanSerializer SPAN_SERIALIZER = new SpanSerializer();
    private static final ReportableEntityDecoder<String, Span> SPAN_DECODER = new SpanDecoder("unknown");
    private final Scanner stdin = new Scanner(System.in);
    private final Supplier<ReportableEntityPreprocessor> preprocessorSupplier;
    private final ReportableEntityType entityType;
    private final String port;
    private final List<String> customSourceTags;
    private final ReportableEntityHandlerFactory factory = new ReportableEntityHandlerFactory(){

        @Override
        public <T, U> ReportableEntityHandler<T, U> getHandler(HandlerKey handlerKey) {
            if (handlerKey.getEntityType() == ReportableEntityType.TRACE) {
                return new ReportableEntityHandler<Span, String>(){

                    @Override
                    public void report(Span reportSpan) {
                        System.out.println(SPAN_SERIALIZER.apply(reportSpan));
                    }

                    @Override
                    public void block(Span reportSpan) {
                        System.out.println("Blocked: " + reportSpan);
                    }

                    @Override
                    public void block(@Nullable Span reportSpan, @Nullable String message) {
                        System.out.println("Blocked: " + SPAN_SERIALIZER.apply(reportSpan));
                    }

                    @Override
                    public void reject(@Nullable Span reportSpan, @Nullable String message) {
                        System.out.println("Rejected: " + SPAN_SERIALIZER.apply(reportSpan));
                    }

                    @Override
                    public void reject(@Nonnull String t, @Nullable String message) {
                        System.out.println("Rejected: " + t);
                    }

                    @Override
                    public void setLogFormat(DataFormat format) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void shutdown() {
                    }
                };
            }
            return new ReportableEntityHandler<ReportPoint, String>(){

                @Override
                public void report(ReportPoint reportPoint) {
                    System.out.println(ReportPointSerializer.pointToString((ReportPoint)reportPoint));
                }

                @Override
                public void block(ReportPoint reportPoint) {
                    System.out.println("Blocked: " + ReportPointSerializer.pointToString((ReportPoint)reportPoint));
                }

                @Override
                public void block(@Nullable ReportPoint reportPoint, @Nullable String message) {
                    System.out.println("Blocked: " + ReportPointSerializer.pointToString((ReportPoint)reportPoint));
                }

                @Override
                public void reject(@Nullable ReportPoint reportPoint, @Nullable String message) {
                    System.out.println("Rejected: " + ReportPointSerializer.pointToString((ReportPoint)reportPoint));
                }

                @Override
                public void reject(@Nonnull String t, @Nullable String message) {
                    System.out.println("Rejected: " + t);
                }

                @Override
                public void setLogFormat(DataFormat format) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void shutdown() {
                }
            };
        }

        @Override
        public void shutdown(@Nonnull String handle) {
        }
    };

    public InteractivePreprocessorTester(Supplier<ReportableEntityPreprocessor> preprocessorSupplier, ReportableEntityType entityType, String port, List<String> customSourceTags) {
        this.preprocessorSupplier = preprocessorSupplier;
        this.entityType = entityType;
        this.port = port;
        this.customSourceTags = customSourceTags;
    }

    @Override
    public boolean interactiveTest() {
        String line = this.stdin.nextLine();
        if (this.entityType == ReportableEntityType.TRACE) {
            ReportableEntityHandler<Span, String> handler = this.factory.getHandler(this.entityType, this.port);
            SpanUtils.preprocessAndHandleSpan(line, SPAN_DECODER, handler, handler::report, this.preprocessorSupplier, null, x -> true);
        } else {
            ReportableEntityHandler<ReportPoint, String> handler = this.factory.getHandler(this.entityType, this.port);
            Object decoder = DataFormat.autodetect(line) == DataFormat.HISTOGRAM ? new ReportPointDecoderWrapper((Decoder)new HistogramDecoder()) : new ReportPointDecoder(() -> "unknown", this.customSourceTags);
            WavefrontPortUnificationHandler.preprocessAndHandlePoint(line, (ReportableEntityDecoder<String, ReportPoint>)decoder, handler, this.preprocessorSupplier, null, "");
        }
        return this.stdin.hasNext();
    }
}

