/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.logsharvesting;

import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.TDigest;
import com.wavefront.agent.logsharvesting.ChangeableGauge;
import com.wavefront.agent.logsharvesting.FlushProcessorContext;
import com.wavefront.common.MetricsToTimeseries;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.DeltaCounter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.WavefrontHistogram;
import com.yammer.metrics.stats.Snapshot;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import wavefront.report.Histogram;
import wavefront.report.HistogramType;

public class FlushProcessor
implements MetricProcessor<FlushProcessorContext> {
    private final Counter sentCounter = Metrics.newCounter((MetricName)new MetricName("logsharvesting", "", "sent"));
    private final Counter histogramCounter = Metrics.newCounter((MetricName)new MetricName("logsharvesting", "", "histograms-sent"));
    private final Supplier<Long> currentMillis;
    private final boolean useWavefrontHistograms;
    private final boolean reportEmptyHistogramStats;

    FlushProcessor(Supplier<Long> currentMillis, boolean useWavefrontHistograms, boolean reportEmptyHistogramStats) {
        this.currentMillis = currentMillis;
        this.useWavefrontHistograms = useWavefrontHistograms;
        this.reportEmptyHistogramStats = reportEmptyHistogramStats;
    }

    public void processMeter(MetricName name, Metered meter, FlushProcessorContext context) {
        throw new UnsupportedOperationException();
    }

    public void processCounter(MetricName name, Counter counter, FlushProcessorContext context) {
        long count;
        if (counter instanceof DeltaCounter) {
            count = DeltaCounter.processDeltaCounter((DeltaCounter)((DeltaCounter)counter));
            if (count == 0L) {
                return;
            }
        } else {
            count = counter.count();
        }
        context.report(count);
        this.sentCounter.inc();
    }

    public void processHistogram(MetricName name, com.yammer.metrics.core.Histogram histogram, FlushProcessorContext context) {
        if (histogram instanceof WavefrontHistogram) {
            WavefrontHistogram wavefrontHistogram = (WavefrontHistogram)histogram;
            if (this.useWavefrontHistograms) {
                if (wavefrontHistogram.count() == 0L) {
                    return;
                }
                for (WavefrontHistogram.MinuteBin bin : wavefrontHistogram.bins(true)) {
                    if (bin.getDist().size() == 0L) continue;
                    int size = bin.getDist().centroids().size();
                    ArrayList<Double> centroids = new ArrayList<Double>(size);
                    ArrayList<Integer> counts = new ArrayList<Integer>(size);
                    for (Centroid centroid : bin.getDist().centroids()) {
                        centroids.add(centroid.mean());
                        counts.add(centroid.count());
                    }
                    context.report(Histogram.newBuilder().setDuration(60000).setType(HistogramType.TDIGEST).setBins(centroids).setCounts(counts).build(), bin.getMinMillis());
                    this.histogramCounter.inc();
                }
            } else {
                AVLTreeDigest tDigest = new AVLTreeDigest(100.0);
                List bins = wavefrontHistogram.bins(true);
                bins.stream().map(WavefrontHistogram.MinuteBin::getDist).forEach(arg_0 -> ((TDigest)tDigest).add(arg_0));
                context.reportSubMetric(tDigest.centroids().stream().mapToLong(Centroid::count).sum(), "count");
                Summarizable summarizable = new Summarizable((TDigest)tDigest){
                    final /* synthetic */ TDigest val$tDigest;
                    {
                        this.val$tDigest = tDigest;
                    }

                    public double max() {
                        return this.val$tDigest.centroids().stream().map(Centroid::mean).max(Comparator.naturalOrder()).orElse(Double.NaN);
                    }

                    public double min() {
                        return this.val$tDigest.centroids().stream().map(Centroid::mean).min(Comparator.naturalOrder()).orElse(Double.NaN);
                    }

                    public double mean() {
                        Centroid mean = this.val$tDigest.centroids().stream().reduce((x, y) -> new Centroid(x.mean() + y.mean() * (double)y.count(), x.count() + y.count())).orElse(null);
                        return mean == null || this.val$tDigest.centroids().size() == 0 ? Double.NaN : mean.mean() / (double)mean.count();
                    }

                    public double stdDev() {
                        return Double.NaN;
                    }

                    public double sum() {
                        return Double.NaN;
                    }
                };
                for (Map.Entry entry : MetricsToTimeseries.explodeSummarizable((Summarizable)summarizable, (boolean)this.reportEmptyHistogramStats).entrySet()) {
                    if (((Double)entry.getValue()).isNaN()) continue;
                    context.reportSubMetric((Double)entry.getValue(), (String)entry.getKey());
                }
                Sampling sampling = () -> this.lambda$processHistogram$0((TDigest)tDigest);
                for (Map.Entry entry : MetricsToTimeseries.explodeSampling((Sampling)sampling, (boolean)this.reportEmptyHistogramStats).entrySet()) {
                    if (((Double)entry.getValue()).isNaN()) continue;
                    context.reportSubMetric((Double)entry.getValue(), (String)entry.getKey());
                }
                this.sentCounter.inc();
            }
        } else {
            context.reportSubMetric(histogram.count(), "count");
            for (Map.Entry entry : MetricsToTimeseries.explodeSummarizable((Summarizable)histogram, (boolean)this.reportEmptyHistogramStats).entrySet()) {
                if (((Double)entry.getValue()).isNaN()) continue;
                context.reportSubMetric((Double)entry.getValue(), (String)entry.getKey());
            }
            for (Map.Entry entry : MetricsToTimeseries.explodeSampling((Sampling)histogram, (boolean)this.reportEmptyHistogramStats).entrySet()) {
                if (((Double)entry.getValue()).isNaN()) continue;
                context.reportSubMetric((Double)entry.getValue(), (String)entry.getKey());
            }
            this.sentCounter.inc();
            histogram.clear();
        }
    }

    public void processTimer(MetricName name, Timer timer, FlushProcessorContext context) {
        throw new UnsupportedOperationException();
    }

    public void processGauge(MetricName name, Gauge<?> gauge, FlushProcessorContext context) {
        ChangeableGauge changeableGauge = (ChangeableGauge)gauge;
        Double value = (Double)changeableGauge.value();
        if (value == null || value.isInfinite() || value.isNaN()) {
            return;
        }
        context.report(value);
        this.sentCounter.inc();
    }

    private /* synthetic */ Snapshot lambda$processHistogram$0(final TDigest tDigest) {
        return new Snapshot(new double[0]){

            public double get75thPercentile() {
                return tDigest.quantile(0.75);
            }

            public double get95thPercentile() {
                return tDigest.quantile(0.95);
            }

            public double get98thPercentile() {
                return tDigest.quantile(0.98);
            }

            public double get999thPercentile() {
                return tDigest.quantile(0.999);
            }

            public double get99thPercentile() {
                return tDigest.quantile(0.99);
            }

            public double getMedian() {
                return tDigest.quantile(0.5);
            }

            public double getValue(double quantile) {
                return tDigest.quantile(quantile);
            }

            public double[] getValues() {
                return new double[0];
            }

            public int size() {
                return (int)tDigest.size();
            }
        };
    }
}

