/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.logsharvesting;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.collect.Sets;
import com.wavefront.agent.config.MetricMatcher;
import com.wavefront.agent.logsharvesting.ChangeableGauge;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.DeltaCounter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.WavefrontHistogram;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EvictingMetricsRegistry {
    private final MetricsRegistry metricsRegistry;
    private final Cache<MetricName, Metric> metricCache;
    private final LoadingCache<MetricMatcher, Set<MetricName>> metricNamesForMetricMatchers;
    private final boolean wavefrontHistograms;
    private final boolean useDeltaCounters;
    private final Supplier<Long> nowMillis;

    EvictingMetricsRegistry(MetricsRegistry metricRegistry, long expiryMillis, boolean wavefrontHistograms, boolean useDeltaCounters, Supplier<Long> nowMillis, Ticker ticker) {
        this.metricsRegistry = metricRegistry;
        this.nowMillis = nowMillis;
        this.wavefrontHistograms = wavefrontHistograms;
        this.useDeltaCounters = useDeltaCounters;
        this.metricCache = Caffeine.newBuilder().expireAfterAccess(expiryMillis, TimeUnit.MILLISECONDS).ticker(ticker).writer((CacheWriter)new CacheWriter<MetricName, Metric>(){

            public void write(@Nonnull MetricName key, @Nonnull Metric value) {
            }

            public void delete(@Nonnull MetricName key, @Nullable Metric value, @Nonnull RemovalCause cause) {
                if ((cause == RemovalCause.EXPIRED || cause == RemovalCause.EXPLICIT) && EvictingMetricsRegistry.this.metricsRegistry.allMetrics().get(key) == value) {
                    EvictingMetricsRegistry.this.metricsRegistry.removeMetric(key);
                }
            }
        }).build();
        this.metricNamesForMetricMatchers = Caffeine.newBuilder().build(metricMatcher -> Sets.newHashSet());
    }

    public Counter getCounter(MetricName metricName, MetricMatcher metricMatcher) {
        if (this.useDeltaCounters) {
            MetricName newMetricName = DeltaCounter.getDeltaCounterMetricName((MetricName)metricName);
            return (Counter)this.put(newMetricName, metricMatcher, key -> DeltaCounter.get((MetricsRegistry)this.metricsRegistry, (MetricName)newMetricName));
        }
        return this.put(metricName, metricMatcher, arg_0 -> ((MetricsRegistry)this.metricsRegistry).newCounter(arg_0));
    }

    public Gauge getGauge(MetricName metricName, MetricMatcher metricMatcher) {
        return this.put(metricName, metricMatcher, key -> this.metricsRegistry.newGauge(key, new ChangeableGauge()));
    }

    public Histogram getHistogram(MetricName metricName, MetricMatcher metricMatcher) {
        return this.put(metricName, metricMatcher, key -> this.wavefrontHistograms ? WavefrontHistogram.get((MetricsRegistry)this.metricsRegistry, (MetricName)key, this.nowMillis) : this.metricsRegistry.newHistogram(metricName, false));
    }

    public synchronized void evict(MetricMatcher evicted) {
        for (MetricName toRemove : Objects.requireNonNull((Set)this.metricNamesForMetricMatchers.get((Object)evicted))) {
            this.metricCache.invalidate((Object)toRemove);
        }
        this.metricNamesForMetricMatchers.invalidate((Object)evicted);
    }

    public void cleanUp() {
        this.metricCache.cleanUp();
    }

    private <M extends Metric> M put(MetricName metricName, MetricMatcher metricMatcher, Function<MetricName, M> getter) {
        Metric cached = (Metric)this.metricCache.getIfPresent((Object)metricName);
        Objects.requireNonNull((Set)this.metricNamesForMetricMatchers.get((Object)metricMatcher)).add(metricName);
        if (cached != null && cached == this.metricsRegistry.allMetrics().get(metricName)) {
            return (M)cached;
        }
        return (M)this.metricCache.asMap().compute(metricName, (name, existing) -> {
            Metric expected = (Metric)this.metricsRegistry.allMetrics().get(name);
            return expected == null ? (Metric)getter.apply((MetricName)name) : expected;
        });
    }
}

