/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners.tracing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.wavefront.agent.auth.TokenAuthenticatorBuilder;
import com.wavefront.agent.channel.ChannelUtils;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.listeners.AbstractHttpOnlyHandler;
import com.wavefront.agent.listeners.FeatureCheckUtils;
import com.wavefront.agent.listeners.tracing.SpanUtils;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.agent.sampler.SpanSampler;
import com.wavefront.common.NamedThreadFactory;
import com.wavefront.common.Utils;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.internal.SpanDerivedMetricsUtils;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.WavefrontSender;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Annotation;
import wavefront.report.Span;
import wavefront.report.SpanLog;
import wavefront.report.SpanLogs;
import zipkin2.SpanBytesDecoderDetector;
import zipkin2.codec.BytesDecoder;

@ChannelHandler.Sharable
public class ZipkinPortUnificationHandler
extends AbstractHttpOnlyHandler
implements Runnable,
Closeable {
    private static final Logger logger = Logger.getLogger(ZipkinPortUnificationHandler.class.getCanonicalName());
    private final ReportableEntityHandler<Span, String> spanHandler;
    private final ReportableEntityHandler<SpanLogs, String> spanLogsHandler;
    @Nullable
    private final WavefrontSender wfSender;
    @Nullable
    private final WavefrontInternalReporter wfInternalReporter;
    private final Supplier<Boolean> traceDisabled;
    private final Supplier<Boolean> spanLogsDisabled;
    private final Supplier<ReportableEntityPreprocessor> preprocessorSupplier;
    private final SpanSampler sampler;
    private final Counter discardedBatches;
    private final Counter processedBatches;
    private final Counter failedBatches;
    private final Counter discardedSpansBySampler;
    private final Counter receivedSpansTotal;
    private final Counter discardedTraces;
    private final Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics;
    private final ScheduledExecutorService scheduledExecutorService;
    private static final Set<String> ZIPKIN_VALID_PATHS = ImmutableSet.of((Object)"/api/v1/spans/", (Object)"/api/v2/spans/");
    private static final String ZIPKIN_VALID_HTTP_METHOD = "POST";
    private static final String ZIPKIN_COMPONENT = "zipkin";
    private static final String DEFAULT_SOURCE = "zipkin";
    private static final String DEFAULT_SERVICE = "defaultService";
    private static final String DEFAULT_SPAN_NAME = "defaultOperation";
    private static final String SPAN_TAG_ERROR = "error";
    private final String proxyLevelApplicationName;
    private final Set<String> traceDerivedCustomTagKeys;
    private static final Logger ZIPKIN_DATA_LOGGER = Logger.getLogger("ZipkinDataLogger");

    public ZipkinPortUnificationHandler(String handle, HealthCheckManager healthCheckManager, ReportableEntityHandlerFactory handlerFactory, @Nullable WavefrontSender wfSender, Supplier<Boolean> traceDisabled, Supplier<Boolean> spanLogsDisabled, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor, SpanSampler sampler, @Nullable String traceZipkinApplicationName, Set<String> traceDerivedCustomTagKeys) {
        this(handle, healthCheckManager, handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.TRACE, handle)), handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.TRACE_SPAN_LOGS, handle)), wfSender, traceDisabled, spanLogsDisabled, preprocessor, sampler, traceZipkinApplicationName, traceDerivedCustomTagKeys);
    }

    @VisibleForTesting
    ZipkinPortUnificationHandler(String handle, HealthCheckManager healthCheckManager, ReportableEntityHandler<Span, String> spanHandler, ReportableEntityHandler<SpanLogs, String> spanLogsHandler, @Nullable WavefrontSender wfSender, Supplier<Boolean> traceDisabled, Supplier<Boolean> spanLogsDisabled, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor, SpanSampler sampler, @Nullable String traceZipkinApplicationName, Set<String> traceDerivedCustomTagKeys) {
        super(TokenAuthenticatorBuilder.create().build(), healthCheckManager, handle);
        this.spanHandler = spanHandler;
        this.spanLogsHandler = spanLogsHandler;
        this.wfSender = wfSender;
        this.traceDisabled = traceDisabled;
        this.spanLogsDisabled = spanLogsDisabled;
        this.preprocessorSupplier = preprocessor;
        this.sampler = sampler;
        this.proxyLevelApplicationName = StringUtils.isBlank((String)traceZipkinApplicationName) ? "Zipkin" : traceZipkinApplicationName.trim();
        this.traceDerivedCustomTagKeys = traceDerivedCustomTagKeys;
        this.discardedBatches = Metrics.newCounter((MetricName)new MetricName("spans." + handle + ".batches", "", "discarded"));
        this.processedBatches = Metrics.newCounter((MetricName)new MetricName("spans." + handle + ".batches", "", "processed"));
        this.failedBatches = Metrics.newCounter((MetricName)new MetricName("spans." + handle + ".batches", "", "failed"));
        this.discardedSpansBySampler = Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "sampler.discarded"));
        this.receivedSpansTotal = Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "received.total"));
        this.discardedTraces = Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "discarded"));
        this.discoveredHeartbeatMetrics = Sets.newConcurrentHashSet();
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("zipkin-heart-beater"));
        this.scheduledExecutorService.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.MINUTES);
        if (wfSender != null) {
            this.wfInternalReporter = new WavefrontInternalReporter.Builder().prefixedWith("tracing.derived").withSource("zipkin").reportMinuteDistribution().build(wfSender);
            this.wfInternalReporter.start(1L, TimeUnit.MINUTES);
        } else {
            this.wfInternalReporter = null;
        }
    }

    @Override
    protected void handleHttpMessage(ChannelHandlerContext ctx, FullHttpRequest request) throws URISyntaxException {
        HttpResponseStatus status;
        String path;
        URI uri = new URI(request.uri());
        String string = path = uri.getPath().endsWith("/") ? uri.getPath() : uri.getPath() + "/";
        if (!ZIPKIN_VALID_PATHS.contains(path)) {
            ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Object)"Unsupported URL path.", (HttpMessage)request);
            this.logWarning("Requested URI path '" + path + "' is not supported.", null, ctx);
            return;
        }
        if (!request.method().toString().equalsIgnoreCase(ZIPKIN_VALID_HTTP_METHOD)) {
            ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Object)"Unsupported Http method.", (HttpMessage)request);
            this.logWarning("Requested http method '" + request.method().toString() + "' is not supported.", null, ctx);
            return;
        }
        StringBuilder output = new StringBuilder();
        try {
            byte[] bytesArray = new byte[request.content().nioBuffer().remaining()];
            request.content().nioBuffer().get(bytesArray, 0, bytesArray.length);
            BytesDecoder decoder = SpanBytesDecoderDetector.decoderForListMessage((byte[])bytesArray);
            ArrayList<zipkin2.Span> zipkinSpanSink = new ArrayList<zipkin2.Span>();
            decoder.decodeList(bytesArray, zipkinSpanSink);
            if (FeatureCheckUtils.isFeatureDisabled(this.traceDisabled, "Ingested span discarded because distributed tracing feature has not been enabled for your account.", this.discardedBatches, output)) {
                HttpResponseStatus status2 = HttpResponseStatus.ACCEPTED;
                ChannelUtils.writeHttpResponse(ctx, status2, (Object)output, (HttpMessage)request);
                this.discardedTraces.inc((long)zipkinSpanSink.size());
                this.receivedSpansTotal.inc((long)zipkinSpanSink.size());
                this.processedBatches.inc();
                return;
            }
            this.receivedSpansTotal.inc((long)zipkinSpanSink.size());
            this.processZipkinSpans(zipkinSpanSink);
            status = HttpResponseStatus.ACCEPTED;
            this.processedBatches.inc();
        }
        catch (Exception e) {
            this.failedBatches.inc();
            output.append(ChannelUtils.errorMessageWithRootCause(e));
            status = HttpResponseStatus.BAD_REQUEST;
            logger.log(Level.WARNING, "Zipkin batch processing failed", Throwables.getRootCause((Throwable)e));
        }
        ChannelUtils.writeHttpResponse(ctx, status, (Object)output, (HttpMessage)request);
    }

    private void processZipkinSpans(List<zipkin2.Span> zipkinSpans) {
        for (zipkin2.Span zipkinSpan : zipkinSpans) {
            this.processZipkinSpan(zipkinSpan);
        }
    }

    private void processZipkinSpan(zipkin2.Span zipkinSpan) {
        boolean isDebug;
        if (ZIPKIN_DATA_LOGGER.isLoggable(Level.FINEST)) {
            ZIPKIN_DATA_LOGGER.info("Inbound Zipkin span: " + zipkinSpan.toString());
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        annotations.add(new Annotation("zipkinSpanId", zipkinSpan.id()));
        annotations.add(new Annotation("zipkinTraceId", zipkinSpan.traceId()));
        if (zipkinSpan.parentId() != null) {
            annotations.add(new Annotation("parent", Utils.convertToUuidString(zipkinSpan.parentId())));
        }
        if (zipkinSpan.kind() != null) {
            String kind = zipkinSpan.kind().toString().toLowerCase();
            annotations.add(new Annotation("span.kind", kind));
            if (zipkinSpan.annotations() != null && !zipkinSpan.annotations().isEmpty()) {
                annotations.add(new Annotation("_spanSecondaryId", kind));
            }
        }
        String serviceName = zipkinSpan.localServiceName() == null ? DEFAULT_SERVICE : zipkinSpan.localServiceName();
        annotations.add(new Annotation("service", serviceName));
        String applicationName = this.proxyLevelApplicationName;
        String cluster = "none";
        String shard = "none";
        String componentTagValue = "none";
        boolean isError = false;
        boolean isDebugSpanTag = false;
        HashSet ignoreKeys = new HashSet(ImmutableSet.of((Object)"source"));
        if (zipkinSpan.tags() != null && zipkinSpan.tags().size() > 0) {
            block32: for (Map.Entry tag : zipkinSpan.tags().entrySet()) {
                if (ignoreKeys.contains(((String)tag.getKey()).toLowerCase()) || StringUtils.isBlank((String)((String)tag.getValue()))) continue;
                Annotation annotation = new Annotation((String)tag.getKey(), (String)tag.getValue());
                switch (annotation.getKey()) {
                    case "application": {
                        applicationName = annotation.getValue();
                        continue block32;
                    }
                    case "cluster": {
                        cluster = annotation.getValue();
                        continue block32;
                    }
                    case "shard": {
                        shard = annotation.getValue();
                        continue block32;
                    }
                    case "component": {
                        componentTagValue = annotation.getValue();
                        break;
                    }
                    case "error": {
                        isError = true;
                        annotation.setValue("true");
                        break;
                    }
                    case "debug": {
                        isDebugSpanTag = annotation.getValue().equals("true");
                    }
                }
                annotations.add(annotation);
            }
        }
        annotations.add(new Annotation("application", applicationName));
        annotations.add(new Annotation("cluster", cluster));
        annotations.add(new Annotation("shard", shard));
        boolean bl = isDebug = zipkinSpan.debug() != null ? zipkinSpan.debug() : false;
        if (!isDebugSpanTag && isDebug) {
            annotations.add(new Annotation("debug", "true"));
        }
        if (zipkinSpan.localEndpoint() != null && zipkinSpan.localEndpoint().ipv4() != null) {
            annotations.add(new Annotation("ipv4", zipkinSpan.localEndpoint().ipv4()));
        }
        if (!this.spanLogsDisabled.get().booleanValue() && zipkinSpan.annotations() != null && !zipkinSpan.annotations().isEmpty()) {
            annotations.add(new Annotation("_spanLogs", "true"));
        }
        String sourceName = "zipkin";
        if (zipkinSpan.tags() != null && zipkinSpan.tags().size() > 0 && zipkinSpan.tags().get("source") != null) {
            sourceName = (String)zipkinSpan.tags().get("source");
        }
        String spanName = zipkinSpan.name() == null ? DEFAULT_SPAN_NAME : zipkinSpan.name();
        String spanId = Utils.convertToUuidString(zipkinSpan.id());
        String traceId = Utils.convertToUuidString(zipkinSpan.traceId());
        Span wavefrontSpan = Span.newBuilder().setCustomer("dummy").setName(spanName).setSource(sourceName).setSpanId(spanId).setTraceId(traceId).setStartMillis(zipkinSpan.timestampAsLong() / 1000L).setDuration(zipkinSpan.durationAsLong() / 1000L).setAnnotations(annotations).build();
        if (zipkinSpan.tags().containsKey(SPAN_TAG_ERROR) && ZIPKIN_DATA_LOGGER.isLoggable(Level.FINER)) {
            ZIPKIN_DATA_LOGGER.info("Span id :: " + spanId + " with trace id :: " + traceId + " , includes error tag :: " + (String)zipkinSpan.tags().get(SPAN_TAG_ERROR));
        }
        if (ZIPKIN_DATA_LOGGER.isLoggable(Level.FINEST)) {
            ZIPKIN_DATA_LOGGER.info("Converted Wavefront span: " + wavefrontSpan.toString());
        }
        if (this.preprocessorSupplier != null) {
            ReportableEntityPreprocessor preprocessor = this.preprocessorSupplier.get();
            String[] messageHolder = new String[1];
            preprocessor.forSpan().transform(wavefrontSpan);
            if (!preprocessor.forSpan().filter(wavefrontSpan, messageHolder)) {
                if (messageHolder[0] != null) {
                    this.spanHandler.reject(wavefrontSpan, messageHolder[0]);
                } else {
                    this.spanHandler.block(wavefrontSpan);
                }
                return;
            }
        }
        if (this.sampler.sample(wavefrontSpan, this.discardedSpansBySampler)) {
            this.spanHandler.report(wavefrontSpan);
            if (zipkinSpan.annotations() != null && !zipkinSpan.annotations().isEmpty() && !FeatureCheckUtils.isFeatureDisabled(this.spanLogsDisabled, "Ingested span log discarded because this feature has not been enabled for your account.", null)) {
                SpanLogs spanLogs = SpanLogs.newBuilder().setCustomer("default").setTraceId(wavefrontSpan.getTraceId()).setSpanId(wavefrontSpan.getSpanId()).setSpanSecondaryId(zipkinSpan.kind() != null ? zipkinSpan.kind().toString().toLowerCase() : null).setLogs(zipkinSpan.annotations().stream().map(x -> SpanLog.newBuilder().setTimestamp(x.timestamp()).setFields((Map)ImmutableMap.of((Object)"annotation", (Object)x.value())).build()).collect(Collectors.toList())).build();
                SpanUtils.addSpanLine(wavefrontSpan, spanLogs);
                this.spanLogsHandler.report(spanLogs);
            }
        }
        if (this.wfInternalReporter != null) {
            List processedAnnotations = wavefrontSpan.getAnnotations();
            block33: for (Annotation processedAnnotation : processedAnnotations) {
                switch (processedAnnotation.getKey()) {
                    case "application": {
                        applicationName = processedAnnotation.getValue();
                        continue block33;
                    }
                    case "service": {
                        serviceName = processedAnnotation.getValue();
                        continue block33;
                    }
                    case "cluster": {
                        cluster = processedAnnotation.getValue();
                        continue block33;
                    }
                    case "shard": {
                        shard = processedAnnotation.getValue();
                        continue block33;
                    }
                    case "component": {
                        componentTagValue = processedAnnotation.getValue();
                        continue block33;
                    }
                    case "error": {
                        isError = true;
                        continue block33;
                    }
                }
            }
            List spanTags = processedAnnotations.stream().map(a -> new Pair((Object)a.getKey(), (Object)a.getValue())).collect(Collectors.toList());
            this.discoveredHeartbeatMetrics.add((Pair<Map<String, String>, String>)SpanDerivedMetricsUtils.reportWavefrontGeneratedData((WavefrontInternalReporter)this.wfInternalReporter, (String)wavefrontSpan.getName(), (String)applicationName, (String)serviceName, (String)cluster, (String)shard, (String)wavefrontSpan.getSource(), (String)componentTagValue, (boolean)isError, (long)zipkinSpan.durationAsLong(), this.traceDerivedCustomTagKeys, spanTags, (boolean)true));
        }
    }

    @Override
    public void run() {
        try {
            SpanDerivedMetricsUtils.reportHeartbeats((WavefrontSender)this.wfSender, this.discoveredHeartbeatMetrics, (String)"zipkin");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Cannot report heartbeat metric to wavefront");
        }
    }

    @Override
    public void close() {
        this.scheduledExecutorService.shutdownNow();
    }
}

