/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners.tracing;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.formatter.DataFormat;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.listeners.AbstractLineDelimitedHandler;
import com.wavefront.agent.listeners.FeatureCheckUtils;
import com.wavefront.agent.listeners.tracing.SpanUtils;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.agent.sampler.SpanSampler;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.ingester.ReportableEntityDecoder;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import wavefront.report.Span;
import wavefront.report.SpanLogs;

@ChannelHandler.Sharable
public class TracePortUnificationHandler
extends AbstractLineDelimitedHandler {
    protected final ReportableEntityHandler<Span, String> handler;
    private final ReportableEntityHandler<SpanLogs, String> spanLogsHandler;
    private final ReportableEntityDecoder<String, Span> decoder;
    private final ReportableEntityDecoder<JsonNode, SpanLogs> spanLogsDecoder;
    private final Supplier<ReportableEntityPreprocessor> preprocessorSupplier;
    private final SpanSampler sampler;
    private final Supplier<Boolean> traceDisabled;
    private final Supplier<Boolean> spanLogsDisabled;
    protected final Counter discardedSpans;
    protected final Counter discardedSpanLogs;
    private final Counter discardedSpansBySampler;
    private final Counter discardedSpanLogsBySampler;
    private final Counter receivedSpansTotal;

    public TracePortUnificationHandler(String handle, TokenAuthenticator tokenAuthenticator, HealthCheckManager healthCheckManager, ReportableEntityDecoder<String, Span> traceDecoder, ReportableEntityDecoder<JsonNode, SpanLogs> spanLogsDecoder, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor, ReportableEntityHandlerFactory handlerFactory, SpanSampler sampler, Supplier<Boolean> traceDisabled, Supplier<Boolean> spanLogsDisabled) {
        this(handle, tokenAuthenticator, healthCheckManager, traceDecoder, spanLogsDecoder, preprocessor, handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.TRACE, handle)), handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.TRACE_SPAN_LOGS, handle)), sampler, traceDisabled, spanLogsDisabled);
    }

    @VisibleForTesting
    public TracePortUnificationHandler(String handle, TokenAuthenticator tokenAuthenticator, HealthCheckManager healthCheckManager, ReportableEntityDecoder<String, Span> traceDecoder, ReportableEntityDecoder<JsonNode, SpanLogs> spanLogsDecoder, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor, ReportableEntityHandler<Span, String> handler, ReportableEntityHandler<SpanLogs, String> spanLogsHandler, SpanSampler sampler, Supplier<Boolean> traceDisabled, Supplier<Boolean> spanLogsDisabled) {
        super(tokenAuthenticator, healthCheckManager, handle);
        this.decoder = traceDecoder;
        this.spanLogsDecoder = spanLogsDecoder;
        this.handler = handler;
        this.spanLogsHandler = spanLogsHandler;
        this.preprocessorSupplier = preprocessor;
        this.sampler = sampler;
        this.traceDisabled = traceDisabled;
        this.spanLogsDisabled = spanLogsDisabled;
        this.discardedSpans = Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "discarded"));
        this.discardedSpanLogs = Metrics.newCounter((MetricName)new MetricName("spanLogs." + handle, "", "discarded"));
        this.discardedSpansBySampler = Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "sampler.discarded"));
        this.discardedSpanLogsBySampler = Metrics.newCounter((MetricName)new MetricName("spanLogs." + handle, "", "sampler.discarded"));
        this.receivedSpansTotal = Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "received.total"));
    }

    @Override
    @Nullable
    protected DataFormat getFormat(FullHttpRequest httpRequest) {
        return DataFormat.parse(URLEncodedUtils.parse((URI)URI.create(httpRequest.uri()), (Charset)CharsetUtil.UTF_8).stream().filter(x -> x.getName().equals("format") || x.getName().equals("f")).map(NameValuePair::getValue).findFirst().orElse(null));
    }

    @Override
    protected void processLine(ChannelHandlerContext ctx, @Nonnull String message, @Nullable DataFormat format) {
        if (format == DataFormat.SPAN_LOG || message.startsWith("{") && message.endsWith("}")) {
            if (FeatureCheckUtils.isFeatureDisabled(this.spanLogsDisabled, "Ingested span log discarded because this feature has not been enabled for your account.", this.discardedSpanLogs)) {
                return;
            }
            SpanUtils.handleSpanLogs(message, this.spanLogsDecoder, this.decoder, this.spanLogsHandler, this.preprocessorSupplier, ctx, span -> this.sampler.sample((Span)span, this.discardedSpanLogsBySampler));
            return;
        }
        this.receivedSpansTotal.inc();
        if (FeatureCheckUtils.isFeatureDisabled(this.traceDisabled, "Ingested span discarded because distributed tracing feature has not been enabled for your account.", this.discardedSpans)) {
            return;
        }
        SpanUtils.preprocessAndHandleSpan(message, this.decoder, this.handler, this::report, this.preprocessorSupplier, ctx, span -> this.sampler.sample((Span)span, this.discardedSpansBySampler));
    }

    protected void report(Span object) {
        this.handler.report(object);
    }
}

