/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners.tracing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.wavefront.agent.channel.ChannelUtils;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.data.AnnotationUtils;
import com.wavefront.ingester.ReportableEntityDecoder;
import io.netty.channel.ChannelHandlerContext;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import wavefront.report.Span;
import wavefront.report.SpanLogs;

public final class SpanUtils {
    private static final Logger logger = Logger.getLogger(SpanUtils.class.getCanonicalName());
    private static final ObjectMapper JSON_PARSER = new ObjectMapper();

    private SpanUtils() {
    }

    public static void preprocessAndHandleSpan(String message, ReportableEntityDecoder<String, Span> decoder, ReportableEntityHandler<Span, String> handler, Consumer<Span> spanReporter, @Nullable Supplier<ReportableEntityPreprocessor> preprocessorSupplier, @Nullable ChannelHandlerContext ctx, Function<Span, Boolean> samplerFunc) {
        ReportableEntityPreprocessor preprocessor = preprocessorSupplier == null ? null : preprocessorSupplier.get();
        String[] messageHolder = new String[1];
        if (preprocessor != null) {
            message = preprocessor.forPointLine().transform(message);
            if (!preprocessor.forPointLine().filter(message, messageHolder)) {
                if (messageHolder[0] != null) {
                    handler.reject((Span)null, messageHolder[0]);
                } else {
                    handler.block(null, message);
                }
                return;
            }
        }
        ArrayList output = new ArrayList(1);
        try {
            decoder.decode((Object)message, output, "dummy");
        }
        catch (Exception e) {
            handler.reject(message, ChannelUtils.formatErrorMessage(message, e, ctx));
            return;
        }
        for (Span object : output) {
            if (preprocessor != null) {
                preprocessor.forSpan().transform(object);
                if (!preprocessor.forSpan().filter(object, messageHolder)) {
                    if (messageHolder[0] != null) {
                        handler.reject(object, messageHolder[0]);
                    } else {
                        handler.block(object);
                    }
                    return;
                }
            }
            if (!samplerFunc.apply(object).booleanValue()) continue;
            spanReporter.accept(object);
        }
    }

    public static void handleSpanLogs(String message, ReportableEntityDecoder<JsonNode, SpanLogs> spanLogsDecoder, ReportableEntityDecoder<String, Span> spanDecoder, ReportableEntityHandler<SpanLogs, String> handler, @Nullable Supplier<ReportableEntityPreprocessor> preprocessorSupplier, @Nullable ChannelHandlerContext ctx, Function<Span, Boolean> samplerFunc) {
        ArrayList spanLogsOutput = new ArrayList(1);
        try {
            spanLogsDecoder.decode((Object)JSON_PARSER.readTree(message), spanLogsOutput, "dummy");
        }
        catch (Exception e) {
            handler.reject(message, ChannelUtils.formatErrorMessage(message, e, ctx));
            return;
        }
        for (SpanLogs spanLogs : spanLogsOutput) {
            String spanMessage = spanLogs.getSpan();
            if (spanMessage == null) {
                SpanUtils.addSpanLine(null, spanLogs);
                handler.report(spanLogs);
                continue;
            }
            ReportableEntityPreprocessor preprocessor = preprocessorSupplier == null ? null : preprocessorSupplier.get();
            String[] spanMessageHolder = new String[1];
            if (preprocessor != null) {
                spanMessage = preprocessor.forPointLine().transform(spanMessage);
                if (!preprocessor.forPointLine().filter(message, spanMessageHolder)) {
                    if (spanMessageHolder[0] != null) {
                        handler.reject(spanLogs, spanMessageHolder[0]);
                    } else {
                        handler.block(spanLogs);
                    }
                    return;
                }
            }
            ArrayList spanOutput = new ArrayList(1);
            try {
                spanDecoder.decode((Object)spanMessage, spanOutput, "dummy");
            }
            catch (Exception e) {
                handler.reject(spanLogs, ChannelUtils.formatErrorMessage(message, e, ctx));
                return;
            }
            if (spanOutput.isEmpty()) continue;
            Span span = (Span)spanOutput.get(0);
            if (preprocessor != null) {
                preprocessor.forSpan().transform(span);
                if (!preprocessor.forSpan().filter(span, spanMessageHolder)) {
                    if (spanMessageHolder[0] != null) {
                        handler.reject(spanLogs, spanMessageHolder[0]);
                    } else {
                        handler.block(spanLogs);
                    }
                    return;
                }
            }
            if (!samplerFunc.apply(span).booleanValue()) continue;
            SpanUtils.addSpanLine(span, spanLogs);
            handler.report(spanLogs);
        }
    }

    public static String toStringId(ByteString id) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(id.toByteArray());
        long mostSigBits = id.toByteArray().length > 8 ? byteBuffer.getLong() : 0L;
        long leastSigBits = new BigInteger(1, byteBuffer.array()).longValue();
        UUID uuid = new UUID(mostSigBits, leastSigBits);
        return uuid.toString();
    }

    public static void addSpanLine(Span span, SpanLogs spanLogs) {
        String policyId = null;
        if (span != null && span.getAnnotations() != null) {
            policyId = AnnotationUtils.getValue((List)span.getAnnotations(), (String)"_sampledByPolicy");
        }
        spanLogs.setSpan("_sampledByPolicy=" + (policyId == null ? "NONE" : policyId));
    }
}

