/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.channel.ChannelUtils;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.listeners.AbstractHttpOnlyHandler;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.ingester.GraphiteDecoder;
import com.wavefront.ingester.ReportPointSerializer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

@ChannelHandler.Sharable
public class WriteHttpJsonPortUnificationHandler
extends AbstractHttpOnlyHandler {
    private static final Logger logger = Logger.getLogger(WriteHttpJsonPortUnificationHandler.class.getCanonicalName());
    private final ReportableEntityHandler<ReportPoint, String> pointHandler;
    private final String defaultHost;
    @Nullable
    private final Supplier<ReportableEntityPreprocessor> preprocessorSupplier;
    private final ObjectMapper jsonParser;
    private final GraphiteDecoder recoder = new GraphiteDecoder(Collections.emptyList());

    public WriteHttpJsonPortUnificationHandler(String handle, TokenAuthenticator authenticator, HealthCheckManager healthCheckManager, ReportableEntityHandlerFactory handlerFactory, String defaultHost, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor) {
        this(handle, authenticator, healthCheckManager, handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.POINT, handle)), defaultHost, preprocessor);
    }

    @VisibleForTesting
    protected WriteHttpJsonPortUnificationHandler(String handle, TokenAuthenticator authenticator, HealthCheckManager healthCheckManager, ReportableEntityHandler<ReportPoint, String> pointHandler, String defaultHost, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor) {
        super(authenticator, healthCheckManager, handle);
        this.pointHandler = pointHandler;
        this.defaultHost = defaultHost;
        this.preprocessorSupplier = preprocessor;
        this.jsonParser = new ObjectMapper();
    }

    @Override
    protected void handleHttpMessage(ChannelHandlerContext ctx, FullHttpRequest request) {
        HttpResponseStatus status = HttpResponseStatus.OK;
        String requestBody = request.content().toString(CharsetUtil.UTF_8);
        try {
            JsonNode metrics = this.jsonParser.readTree(requestBody);
            if (!metrics.isArray()) {
                logger.warning("metrics is not an array!");
                this.pointHandler.reject((ReportPoint)null, "[metrics] is not an array!");
                status = HttpResponseStatus.BAD_REQUEST;
                ChannelUtils.writeHttpResponse(ctx, status, (Object)"", (HttpMessage)request);
                return;
            }
            this.reportMetrics(metrics);
            ChannelUtils.writeHttpResponse(ctx, status, (Object)"", (HttpMessage)request);
        }
        catch (Exception e) {
            status = HttpResponseStatus.BAD_REQUEST;
            this.logWarning("WF-300: Failed to handle incoming write_http request", e, ctx);
            ChannelUtils.writeHttpResponse(ctx, status, (Object)ChannelUtils.errorMessageWithRootCause(e), (HttpMessage)request);
        }
    }

    private void reportMetrics(JsonNode metrics) {
        ReportableEntityPreprocessor preprocessor = this.preprocessorSupplier == null ? null : this.preprocessorSupplier.get();
        String[] messageHolder = new String[1];
        for (JsonNode metric : metrics) {
            JsonNode values;
            String hostName;
            JsonNode host = metric.get("host");
            if (host != null) {
                hostName = host.textValue();
                if (hostName == null || hostName.isEmpty()) {
                    hostName = this.defaultHost;
                }
            } else {
                hostName = this.defaultHost;
            }
            JsonNode time = metric.get("time");
            long ts = 0L;
            if (time != null) {
                ts = time.asLong() * 1000L;
            }
            if ((values = metric.get("values")) == null) {
                this.pointHandler.reject((ReportPoint)null, "[values] missing in JSON object");
                logger.warning("Skipping - [values] missing in JSON object.");
                continue;
            }
            int index = 0;
            for (JsonNode value : values) {
                String metricName = WriteHttpJsonPortUnificationHandler.getMetricName(metric, index);
                ReportPoint.Builder builder = ReportPoint.newBuilder().setMetric(metricName).setTable("dummy").setTimestamp(ts).setHost(hostName);
                if (value.isDouble()) {
                    builder.setValue(value.asDouble());
                } else {
                    builder.setValue(value.asLong());
                }
                ArrayList<ReportPoint> parsedPoints = new ArrayList<ReportPoint>(1);
                ReportPoint point = builder.build();
                if (preprocessor != null && preprocessor.forPointLine().getTransformers().size() > 0) {
                    String pointLine = ReportPointSerializer.pointToString((ReportPoint)point);
                    pointLine = preprocessor.forPointLine().transform(pointLine);
                    this.recoder.decodeReportPoints(pointLine, parsedPoints, "dummy");
                } else {
                    parsedPoints.add(point);
                }
                for (ReportPoint parsedPoint : parsedPoints) {
                    if (preprocessor != null) {
                        preprocessor.forReportPoint().transform(point);
                        if (!preprocessor.forReportPoint().filter(point, messageHolder)) {
                            if (messageHolder[0] != null) {
                                this.pointHandler.reject(point, messageHolder[0]);
                                continue;
                            }
                            this.pointHandler.block(point);
                            continue;
                        }
                    }
                    this.pointHandler.report(parsedPoint);
                }
                ++index;
            }
        }
    }

    private static String getMetricName(JsonNode metric, int index) {
        JsonNode plugin = metric.get("plugin");
        JsonNode plugin_instance = metric.get("plugin_instance");
        JsonNode type = metric.get("type");
        JsonNode type_instance = metric.get("type_instance");
        if (plugin == null || type == null) {
            throw new IllegalArgumentException("plugin or type is missing");
        }
        StringBuilder sb = new StringBuilder();
        WriteHttpJsonPortUnificationHandler.extractMetricFragment(plugin, plugin_instance, sb);
        WriteHttpJsonPortUnificationHandler.extractMetricFragment(type, type_instance, sb);
        JsonNode dsnames = metric.get("dsnames");
        if (dsnames == null || !dsnames.isArray() || dsnames.size() <= index) {
            throw new IllegalArgumentException("dsnames is not set");
        }
        sb.append(dsnames.get(index).textValue());
        return sb.toString();
    }

    private static void extractMetricFragment(JsonNode node, JsonNode instance_node, StringBuilder sb) {
        String value;
        sb.append(node.textValue());
        sb.append('.');
        if (instance_node != null && (value = instance_node.textValue()) != null && !value.isEmpty()) {
            sb.append(value);
            sb.append('.');
        }
    }
}

