/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.channel.ChannelUtils;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.listeners.AbstractHttpOnlyHandler;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.common.Clock;
import com.wavefront.common.Pair;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.metrics.JsonMetricsParser;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

@ChannelHandler.Sharable
public class JsonMetricsPortUnificationHandler
extends AbstractHttpOnlyHandler {
    private static final Set<String> STANDARD_PARAMS = ImmutableSet.of((Object)"h", (Object)"p", (Object)"d", (Object)"t");
    private final ReportableEntityHandler<ReportPoint, String> pointHandler;
    private final String prefix;
    private final String defaultHost;
    @Nullable
    private final Supplier<ReportableEntityPreprocessor> preprocessorSupplier;
    private final ObjectMapper jsonParser;

    public JsonMetricsPortUnificationHandler(String handle, TokenAuthenticator authenticator, HealthCheckManager healthCheckManager, ReportableEntityHandlerFactory handlerFactory, String prefix, String defaultHost, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor) {
        this(handle, authenticator, healthCheckManager, handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.POINT, handle)), prefix, defaultHost, preprocessor);
    }

    @VisibleForTesting
    protected JsonMetricsPortUnificationHandler(String handle, TokenAuthenticator authenticator, HealthCheckManager healthCheckManager, ReportableEntityHandler<ReportPoint, String> pointHandler, String prefix, String defaultHost, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor) {
        super(authenticator, healthCheckManager, handle);
        this.pointHandler = pointHandler;
        this.prefix = prefix;
        this.defaultHost = defaultHost;
        this.preprocessorSupplier = preprocessor;
        this.jsonParser = new ObjectMapper();
    }

    @Override
    protected void handleHttpMessage(ChannelHandlerContext ctx, FullHttpRequest request) throws URISyntaxException {
        StringBuilder output = new StringBuilder();
        try {
            long timestamp;
            URI uri = new URI(request.uri());
            Map<String, String> params = Arrays.stream(uri.getRawQuery().split("&")).map(x -> new Pair((Object)x.split("=")[0].trim().toLowerCase(), (Object)x.split("=")[1])).collect(Collectors.toMap(k -> (String)k._1, v -> (String)v._2));
            String requestBody = request.content().toString(CharsetUtil.UTF_8);
            HashMap tags = Maps.newHashMap();
            params.entrySet().stream().filter(x -> !STANDARD_PARAMS.contains(x.getKey()) && ((String)x.getValue()).length() > 0).forEach(x -> tags.put((String)x.getKey(), (String)x.getValue()));
            ArrayList points = new ArrayList();
            if (params.get("d") == null) {
                timestamp = Clock.now();
            } else {
                try {
                    timestamp = Long.parseLong(params.get("d"));
                }
                catch (NumberFormatException e) {
                    timestamp = Clock.now();
                }
            }
            String prefix = this.prefix == null ? params.get("p") : (params.get("p") == null ? this.prefix : this.prefix + "." + params.get("p"));
            String host = params.get("h") == null ? this.defaultHost : params.get("h");
            JsonNode metrics = this.jsonParser.readTree(requestBody);
            ReportableEntityPreprocessor preprocessor = this.preprocessorSupplier == null ? null : this.preprocessorSupplier.get();
            String[] messageHolder = new String[1];
            JsonMetricsParser.report((String)"dummy", (String)prefix, (JsonNode)metrics, points, (String)host, (long)timestamp);
            for (ReportPoint point : points) {
                if (point.getAnnotations().isEmpty()) {
                    point.setAnnotations((Map)tags);
                } else {
                    HashMap newAnnotations = Maps.newHashMap((Map)tags);
                    newAnnotations.putAll(point.getAnnotations());
                    point.setAnnotations((Map)newAnnotations);
                }
                if (preprocessor != null) {
                    preprocessor.forReportPoint().transform(point);
                    if (!preprocessor.forReportPoint().filter(point, messageHolder)) {
                        if (messageHolder[0] != null) {
                            this.pointHandler.reject(point, messageHolder[0]);
                            continue;
                        }
                        this.pointHandler.block(point);
                        continue;
                    }
                }
                this.pointHandler.report(point);
            }
            ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.OK, (Object)output, (HttpMessage)request);
        }
        catch (IOException e) {
            this.logWarning("WF-300: Error processing incoming JSON request", e, ctx);
            ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, (Object)output, (HttpMessage)request);
        }
    }
}

