/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners;

import com.google.common.base.Throwables;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.ingester.GraphiteDecoder;
import com.wavefront.ingester.ReportPointSerializer;
import com.wavefront.ingester.ReportableEntityDecoder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

@ChannelHandler.Sharable
public class ChannelByteArrayHandler
extends SimpleChannelInboundHandler<byte[]> {
    private static final Logger logger = Logger.getLogger(ChannelByteArrayHandler.class.getCanonicalName());
    private final ReportableEntityDecoder<byte[], ReportPoint> decoder;
    private final ReportableEntityHandler<ReportPoint, String> pointHandler;
    @Nullable
    private final Supplier<ReportableEntityPreprocessor> preprocessorSupplier;
    private final Logger blockedItemsLogger;
    private final GraphiteDecoder recoder;

    public ChannelByteArrayHandler(ReportableEntityDecoder<byte[], ReportPoint> decoder, ReportableEntityHandler<ReportPoint, String> pointHandler, @Nullable Supplier<ReportableEntityPreprocessor> preprocessorSupplier, Logger blockedItemsLogger) {
        this.decoder = decoder;
        this.pointHandler = pointHandler;
        this.preprocessorSupplier = preprocessorSupplier;
        this.blockedItemsLogger = blockedItemsLogger;
        this.recoder = new GraphiteDecoder(Collections.emptyList());
    }

    protected void channelRead0(ChannelHandlerContext ctx, byte[] msg) {
        if (msg == null || msg.length == 0) {
            return;
        }
        ReportableEntityPreprocessor preprocessor = this.preprocessorSupplier == null ? null : this.preprocessorSupplier.get();
        ArrayList points = new ArrayList(1);
        try {
            this.decoder.decode((Object)msg, points, "dummy");
            for (ReportPoint point : points) {
                if (preprocessor != null && !preprocessor.forPointLine().getTransformers().isEmpty()) {
                    String pointLine = ReportPointSerializer.pointToString((ReportPoint)point);
                    pointLine = preprocessor.forPointLine().transform(pointLine);
                    ArrayList parsedPoints = new ArrayList(1);
                    this.recoder.decodeReportPoints(pointLine, parsedPoints, "dummy");
                    parsedPoints.forEach(x -> this.preprocessAndReportPoint((ReportPoint)x, preprocessor));
                    continue;
                }
                this.preprocessAndReportPoint(point, preprocessor);
            }
        }
        catch (Exception e) {
            InetSocketAddress remoteAddress;
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            String errMsg = "WF-300 Cannot parse: \"\", reason: \"" + e.getMessage() + "\"";
            if (rootCause != null && rootCause.getMessage() != null) {
                errMsg = errMsg + ", root cause: \"" + rootCause.getMessage() + "\"";
            }
            if ((remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress()) != null) {
                errMsg = errMsg + "; remote: " + remoteAddress.getHostString();
            }
            logger.log(Level.WARNING, errMsg, e);
            this.pointHandler.block(null, errMsg);
        }
    }

    private void preprocessAndReportPoint(ReportPoint point, ReportableEntityPreprocessor preprocessor) {
        String[] messageHolder = new String[1];
        if (preprocessor == null) {
            this.pointHandler.report(point);
            return;
        }
        if (!preprocessor.forPointLine().filter(point.getMetric(), messageHolder)) {
            if (messageHolder[0] != null) {
                this.blockedItemsLogger.warning(ReportPointSerializer.pointToString((ReportPoint)point));
            } else {
                this.blockedItemsLogger.info(ReportPointSerializer.pointToString((ReportPoint)point));
            }
            this.pointHandler.block(point, messageHolder[0]);
            return;
        }
        preprocessor.forReportPoint().transform(point);
        if (!preprocessor.forReportPoint().filter(point, messageHolder)) {
            if (messageHolder[0] != null) {
                this.blockedItemsLogger.warning(ReportPointSerializer.pointToString((ReportPoint)point));
            } else {
                this.blockedItemsLogger.info(ReportPointSerializer.pointToString((ReportPoint)point));
            }
            this.pointHandler.block(point, messageHolder[0]);
            return;
        }
        this.pointHandler.report(point);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        InetSocketAddress remoteAddress;
        if (cause.getMessage().contains("Connection reset by peer")) {
            return;
        }
        Throwable rootCause = Throwables.getRootCause((Throwable)cause);
        String message = "WF-301 Error while receiving data, reason: \"" + cause.getMessage() + "\"";
        if (rootCause != null && rootCause.getMessage() != null) {
            message = message + ", root cause: \"" + rootCause.getMessage() + "\"";
        }
        if ((remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress()) != null) {
            message = message + "; remote: " + remoteAddress.getHostString();
        }
        logger.warning(message);
    }
}

