/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners;

import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.channel.ChannelUtils;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.listeners.AbstractHttpOnlyHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

@ChannelHandler.Sharable
public class AdminPortUnificationHandler
extends AbstractHttpOnlyHandler {
    private static final Logger logger = Logger.getLogger(AdminPortUnificationHandler.class.getCanonicalName());
    private static final Pattern PATH = Pattern.compile("/(enable|disable|status)/?(\\d*)/?");
    private final String remoteIpAllowRegex;

    public AdminPortUnificationHandler(@Nullable TokenAuthenticator tokenAuthenticator, @Nullable HealthCheckManager healthCheckManager, @Nullable String handle, @Nullable String remoteIpAllowRegex) {
        super(tokenAuthenticator, healthCheckManager, handle);
        this.remoteIpAllowRegex = remoteIpAllowRegex;
    }

    @Override
    protected void handleHttpMessage(ChannelHandlerContext ctx, FullHttpRequest request) throws URISyntaxException {
        HttpResponseStatus status;
        StringBuilder output = new StringBuilder();
        String remoteIp = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress();
        if (this.remoteIpAllowRegex != null && !Pattern.compile(this.remoteIpAllowRegex).matcher(remoteIp).matches()) {
            logger.warning("Incoming request from non-allowed remote address " + remoteIp + " rejected!");
            ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.UNAUTHORIZED, (Object)output, (HttpMessage)request);
            return;
        }
        URI uri = new URI(request.uri());
        Matcher path = PATH.matcher(uri.getPath());
        if (path.matches()) {
            Integer port;
            String strPort = path.group(2);
            Integer n = port = NumberUtils.isNumber((String)strPort) ? Integer.valueOf(Integer.parseInt(strPort)) : null;
            if (StringUtils.isBlank((String)strPort) || port != null) {
                switch (path.group(1)) {
                    case "status": {
                        if (request.method().equals((Object)HttpMethod.GET)) {
                            if (port == null) {
                                output.append("Status check requires a specific port");
                                status = HttpResponseStatus.BAD_REQUEST;
                                break;
                            }
                            status = this.healthCheck.isHealthy(port) ? HttpResponseStatus.OK : HttpResponseStatus.SERVICE_UNAVAILABLE;
                            output.append(status.reasonPhrase());
                            break;
                        }
                        status = HttpResponseStatus.METHOD_NOT_ALLOWED;
                        break;
                    }
                    case "enable": {
                        if (request.method().equals((Object)HttpMethod.POST)) {
                            if (port == null) {
                                logger.info("Request to mark all HTTP ports as healthy from remote: " + remoteIp);
                                this.healthCheck.setAllHealthy();
                            } else {
                                logger.info("Marking HTTP port " + port + " as healthy, remote: " + remoteIp);
                                this.healthCheck.setHealthy(port);
                            }
                            status = HttpResponseStatus.OK;
                            break;
                        }
                        status = HttpResponseStatus.METHOD_NOT_ALLOWED;
                        break;
                    }
                    case "disable": {
                        if (request.method().equals((Object)HttpMethod.POST)) {
                            if (port == null) {
                                logger.info("Request to mark all HTTP ports as unhealthy from remote: " + remoteIp);
                                this.healthCheck.setAllUnhealthy();
                            } else {
                                logger.info("Marking HTTP port " + port + " as unhealthy, remote: " + remoteIp);
                                this.healthCheck.setUnhealthy(port);
                            }
                            status = HttpResponseStatus.OK;
                            break;
                        }
                        status = HttpResponseStatus.METHOD_NOT_ALLOWED;
                        break;
                    }
                    default: {
                        status = HttpResponseStatus.BAD_REQUEST;
                        break;
                    }
                }
            } else {
                status = HttpResponseStatus.BAD_REQUEST;
            }
        } else {
            status = HttpResponseStatus.NOT_FOUND;
        }
        ChannelUtils.writeHttpResponse(ctx, status, (Object)output, (HttpMessage)request);
    }
}

