/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.histogram.accumulator;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.annotations.VisibleForTesting;
import com.tdunning.math.stats.AgentDigest;
import com.tdunning.math.stats.TDigest;
import com.wavefront.agent.SharedMetricsRegistry;
import com.wavefront.agent.histogram.HistogramKey;
import com.wavefront.agent.histogram.HistogramUtils;
import com.wavefront.agent.histogram.accumulator.Accumulator;
import com.wavefront.agent.histogram.accumulator.AgentDigestFactory;
import com.wavefront.common.TimeProvider;
import com.wavefront.common.logger.SharedRateLimitingLogger;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Histogram;

public class AccumulationCache
implements Accumulator {
    private static final Logger logger = Logger.getLogger(AccumulationCache.class.getCanonicalName());
    private static final MetricsRegistry sharedRegistry = SharedMetricsRegistry.getInstance();
    private final Counter binCreatedCounter;
    private final Counter binMergedCounter;
    private final Counter cacheBinCreatedCounter;
    private final Counter cacheBinMergedCounter;
    private final Counter flushedCounter;
    private final Counter cacheOverflowCounter = Metrics.newCounter((MetricName)new MetricName("histogram.accumulator.cache", "", "size_exceeded"));
    private final boolean cacheEnabled;
    private final Cache<HistogramKey, AgentDigest> cache;
    private final ConcurrentMap<HistogramKey, AgentDigest> backingStore;
    private final AgentDigestFactory agentDigestFactory;
    private final ConcurrentMap<HistogramKey, Long> keyIndex;

    public AccumulationCache(ConcurrentMap<HistogramKey, AgentDigest> backingStore, AgentDigestFactory agentDigestFactory, long cacheSize, String metricPrefix, @Nullable Ticker ticker) {
        this(backingStore, agentDigestFactory, cacheSize, metricPrefix, ticker, null);
    }

    @VisibleForTesting
    protected AccumulationCache(final ConcurrentMap<HistogramKey, AgentDigest> backingStore, AgentDigestFactory agentDigestFactory, long cacheSize, String metricPrefix, @Nullable Ticker ticker, @Nullable Runnable onFailure) {
        Runnable failureHandler;
        this.backingStore = backingStore;
        this.agentDigestFactory = agentDigestFactory;
        this.cacheEnabled = cacheSize > 0L;
        this.binCreatedCounter = Metrics.newCounter((MetricName)new MetricName(metricPrefix, "", "bin_created"));
        this.binMergedCounter = Metrics.newCounter((MetricName)new MetricName(metricPrefix, "", "bin_merged"));
        MetricsRegistry metricsRegistry = this.cacheEnabled ? Metrics.defaultRegistry() : sharedRegistry;
        this.cacheBinCreatedCounter = metricsRegistry.newCounter(new MetricName(metricPrefix + ".cache", "", "bin_created"));
        this.cacheBinMergedCounter = metricsRegistry.newCounter(new MetricName(metricPrefix + ".cache", "", "bin_merged"));
        this.flushedCounter = Metrics.newCounter((MetricName)new MetricName(metricPrefix + ".cache", "", "flushed"));
        this.keyIndex = new ConcurrentHashMap<HistogramKey, Long>(backingStore.size());
        Runnable runnable = failureHandler = onFailure == null ? new AccumulationCacheMonitor() : onFailure;
        if (backingStore.size() > 0) {
            logger.info("Started: Indexing histogram accumulator");
            for (Map.Entry entry : this.backingStore.entrySet()) {
                this.keyIndex.put((HistogramKey)entry.getKey(), ((AgentDigest)((Object)entry.getValue())).getDispatchTimeMillis());
            }
            logger.info("Finished: Indexing histogram accumulator");
        }
        this.cache = Caffeine.newBuilder().maximumSize(cacheSize).ticker(ticker == null ? Ticker.systemTicker() : ticker).writer((CacheWriter)new CacheWriter<HistogramKey, AgentDigest>(){

            public void write(@Nonnull HistogramKey key, @Nonnull AgentDigest value) {
            }

            public void delete(@Nonnull HistogramKey key, @Nullable AgentDigest value, @Nonnull RemovalCause cause) {
                if (value == null) {
                    return;
                }
                AccumulationCache.this.flushedCounter.inc();
                if (cause == RemovalCause.SIZE && AccumulationCache.this.cacheEnabled) {
                    AccumulationCache.this.cacheOverflowCounter.inc();
                }
                try {
                    AgentDigest merged = backingStore.merge(key, value, (digestA, digestB) -> {
                        if (digestA.centroidCount() >= digestB.centroidCount()) {
                            digestA.add((TDigest)digestB);
                            return digestA;
                        }
                        digestB.add((TDigest)digestA);
                        return digestB;
                    });
                    if (merged == value) {
                        AccumulationCache.this.binCreatedCounter.inc();
                    } else {
                        AccumulationCache.this.binMergedCounter.inc();
                    }
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().contains("Attempt to allocate")) {
                        failureHandler.run();
                    }
                    throw e;
                }
            }
        }).build();
    }

    @VisibleForTesting
    Cache<HistogramKey, AgentDigest> getCache() {
        return this.cache;
    }

    @Override
    public void put(HistogramKey key, @Nonnull AgentDigest value) {
        this.cache.asMap().compute(key, (? super K k, ? super V v) -> {
            if (v == null) {
                if (this.cacheEnabled) {
                    this.cacheBinCreatedCounter.inc();
                }
                this.keyIndex.put(key, value.getDispatchTimeMillis());
                return value;
            }
            if (this.cacheEnabled) {
                this.cacheBinMergedCounter.inc();
            }
            this.keyIndex.compute(key, (? super K k1, ? super V v1) -> v1 != null && v1 < v.getDispatchTimeMillis() ? v1.longValue() : v.getDispatchTimeMillis());
            v.add((TDigest)value);
            return v;
        });
    }

    @Override
    public void put(HistogramKey key, double value) {
        this.cache.asMap().compute(key, (? super K k, ? super V v) -> {
            if (v == null) {
                if (this.cacheEnabled) {
                    this.cacheBinCreatedCounter.inc();
                }
                AgentDigest t = this.agentDigestFactory.newDigest();
                this.keyIndex.compute(key, (? super K k1, ? super V v1) -> v1 != null && v1 < t.getDispatchTimeMillis() ? v1.longValue() : t.getDispatchTimeMillis());
                t.add(value);
                return t;
            }
            if (this.cacheEnabled) {
                this.cacheBinMergedCounter.inc();
            }
            this.keyIndex.compute(key, (? super K k1, ? super V v1) -> v1 != null && v1 < v.getDispatchTimeMillis() ? v1.longValue() : v.getDispatchTimeMillis());
            v.add(value);
            return v;
        });
    }

    @Override
    public void put(HistogramKey key, Histogram value) {
        this.cache.asMap().compute(key, (? super K k, ? super V v) -> {
            if (v == null) {
                if (this.cacheEnabled) {
                    this.cacheBinCreatedCounter.inc();
                }
                AgentDigest t = this.agentDigestFactory.newDigest();
                this.keyIndex.compute(key, (? super K k1, ? super V v1) -> v1 != null && v1 < t.getDispatchTimeMillis() ? v1.longValue() : t.getDispatchTimeMillis());
                HistogramUtils.mergeHistogram((TDigest)t, value);
                return t;
            }
            if (this.cacheEnabled) {
                this.cacheBinMergedCounter.inc();
            }
            this.keyIndex.compute(key, (? super K k1, ? super V v1) -> v1 != null && v1 < v.getDispatchTimeMillis() ? v1.longValue() : v.getDispatchTimeMillis());
            HistogramUtils.mergeHistogram((TDigest)v, value);
            return v;
        });
    }

    @Override
    public Iterator<HistogramKey> getRipeDigestsIterator(final TimeProvider clock) {
        return new Iterator<HistogramKey>(){
            private final Iterator<Map.Entry<HistogramKey, Long>> indexIterator;
            private HistogramKey nextHistogramKey;
            {
                this.indexIterator = AccumulationCache.this.keyIndex.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.indexIterator.hasNext()) {
                    Map.Entry<HistogramKey, Long> entry = this.indexIterator.next();
                    if (entry.getValue() >= clock.currentTimeMillis()) continue;
                    this.nextHistogramKey = entry.getKey();
                    return true;
                }
                return false;
            }

            @Override
            public HistogramKey next() {
                return this.nextHistogramKey;
            }

            @Override
            public void remove() {
                this.indexIterator.remove();
            }
        };
    }

    @Override
    public AgentDigest compute(HistogramKey key, BiFunction<? super HistogramKey, ? super AgentDigest, ? extends AgentDigest> remappingFunction) {
        return this.backingStore.compute(key, remappingFunction);
    }

    @Override
    public long size() {
        return this.backingStore.size();
    }

    @Override
    public void flush() {
        this.cache.invalidateAll();
    }

    static /* synthetic */ Logger access$700() {
        return logger;
    }

    private static class AccumulationCacheMonitor
    implements Runnable {
        private final Logger throttledLogger = new SharedRateLimitingLogger(AccumulationCache.access$700(), "accumulator-failure", 1.0);
        private Counter failureCounter;

        private AccumulationCacheMonitor() {
        }

        @Override
        public void run() {
            if (this.failureCounter == null) {
                this.failureCounter = Metrics.newCounter((MetricName)new MetricName("histogram.accumulator", "", "failure"));
            }
            this.failureCounter.inc();
            this.throttledLogger.severe("CRITICAL: Histogram accumulator overflow - losing histogram data!!! Accumulator size configuration setting is not appropriate for the current workload, please increase the value as appropriate and restart the proxy!");
        }
    }
}

