/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.histogram;

import com.google.common.base.Preconditions;
import com.tdunning.math.stats.AgentDigest;
import com.tdunning.math.stats.TDigest;
import com.wavefront.agent.histogram.Granularity;
import com.wavefront.agent.histogram.HistogramKey;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import wavefront.report.Histogram;
import wavefront.report.ReportPoint;

public final class HistogramUtils {
    private HistogramUtils() {
    }

    public static HistogramKey makeKey(ReportPoint point, Granularity granularity) {
        Preconditions.checkNotNull((Object)point);
        Preconditions.checkNotNull((Object)((Object)granularity));
        String[] annotations = null;
        if (point.getAnnotations() != null) {
            List keyOrderedTags = point.getAnnotations().entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
            annotations = new String[keyOrderedTags.size() * 2];
            for (int i = 0; i < keyOrderedTags.size(); ++i) {
                annotations[2 * i] = (String)((Map.Entry)keyOrderedTags.get(i)).getKey();
                annotations[2 * i + 1] = (String)((Map.Entry)keyOrderedTags.get(i)).getValue();
            }
        }
        return new HistogramKey((byte)granularity.ordinal(), granularity.getBinId(point.getTimestamp()), point.getMetric(), point.getHost(), annotations);
    }

    public static ReportPoint pointFromKeyAndDigest(HistogramKey histogramKey, AgentDigest agentDigest) {
        return ReportPoint.newBuilder().setTimestamp(histogramKey.getBinTimeMillis()).setMetric(histogramKey.getMetric()).setHost(histogramKey.getSource()).setAnnotations(histogramKey.getTagsAsMap()).setTable("dummy").setValue(agentDigest.toHistogram((int)histogramKey.getBinDurationInMillis())).build();
    }

    public static String granularityToString(@Nullable Granularity granularity) {
        return granularity == null ? "distribution" : granularity.toString();
    }

    public static void mergeHistogram(TDigest target, Histogram source) {
        List means = source.getBins();
        List counts = source.getCounts();
        if (means != null && counts != null) {
            int len = Math.min(means.size(), counts.size());
            for (int i = 0; i < len; ++i) {
                Integer count = (Integer)counts.get(i);
                Double mean = (Double)means.get(i);
                if (count == null || count <= 0 || mean == null || !Double.isFinite(mean)) continue;
                target.add(mean.doubleValue(), count.intValue());
            }
        }
    }

    public static class HistogramKeyMarshaller
    implements BytesReader<HistogramKey>,
    BytesWriter<HistogramKey>,
    ReadResolvable<HistogramKeyMarshaller> {
        private static final HistogramKeyMarshaller INSTANCE = new HistogramKeyMarshaller();
        private static final com.yammer.metrics.core.Histogram accumulatorKeySizes = Metrics.newHistogram((MetricName)new MetricName("histogram", "", "accumulatorKeySize"));

        private HistogramKeyMarshaller() {
        }

        public static HistogramKeyMarshaller get() {
            return INSTANCE;
        }

        @Nonnull
        public HistogramKeyMarshaller readResolve() {
            return INSTANCE;
        }

        private static void writeString(Bytes out, String s) {
            Preconditions.checkArgument((s == null || s.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (Object)"String too long (more than 32K)");
            byte[] bytes = s == null ? new byte[]{} : s.getBytes(StandardCharsets.UTF_8);
            out.writeShort((short)bytes.length);
            out.write(bytes);
        }

        private static String readString(Bytes in) {
            byte[] bytes = new byte[in.readShort()];
            in.read(bytes);
            return new String(bytes);
        }

        public void readMarshallable(@Nonnull WireIn wire) throws IORuntimeException {
        }

        public void writeMarshallable(@Nonnull WireOut wire) {
        }

        @Nonnull
        public HistogramKey read(Bytes in, @Nullable HistogramKey using) {
            if (using == null) {
                using = new HistogramKey();
            }
            using.setGranularityOrdinal(in.readByte());
            using.setBinId(in.readInt());
            using.setMetric(HistogramKeyMarshaller.readString(in));
            using.setSource(HistogramKeyMarshaller.readString(in));
            int numTags = in.readShort();
            if (numTags > 0) {
                String[] tags = new String[numTags];
                for (int i = 0; i < numTags; ++i) {
                    tags[i] = HistogramKeyMarshaller.readString(in);
                }
                using.setTags(tags);
            }
            return using;
        }

        public void write(Bytes out, @Nonnull HistogramKey toWrite) {
            int accumulatorKeySize = 5;
            out.writeByte(toWrite.getGranularityOrdinal());
            out.writeInt(toWrite.getBinId());
            accumulatorKeySize += 2 + toWrite.getMetric().length();
            HistogramKeyMarshaller.writeString(out, toWrite.getMetric());
            accumulatorKeySize += 2 + (toWrite.getSource() == null ? 0 : toWrite.getSource().length());
            HistogramKeyMarshaller.writeString(out, toWrite.getSource());
            short numTags = toWrite.getTags() == null ? (short)0 : (short)toWrite.getTags().length;
            accumulatorKeySize += 2;
            out.writeShort(numTags);
            for (short i = 0; i < numTags; i = (short)(i + 1)) {
                String tag = toWrite.getTags()[i];
                accumulatorKeySize += 2 + (tag == null ? 0 : tag.length());
                HistogramKeyMarshaller.writeString(out, tag);
            }
            accumulatorKeySizes.update(accumulatorKeySize);
        }
    }
}

