/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.histogram;

import com.google.common.annotations.VisibleForTesting;
import com.tdunning.math.stats.AgentDigest;
import com.tdunning.math.stats.TDigest;
import com.wavefront.agent.histogram.HistogramUtils;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.common.Utils;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import wavefront.report.Histogram;
import wavefront.report.HistogramType;

public class HistogramRecompressor
implements Function<Histogram, Histogram> {
    private final Supplier<Short> storageAccuracySupplier;
    private final Supplier<Counter> histogramsCompacted = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new TaggedMetricName("histogram", "histograms_compacted")));
    private final Supplier<Counter> histogramsRecompressed = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new TaggedMetricName("histogram", "histograms_recompressed")));

    public HistogramRecompressor(Supplier<Short> storageAccuracySupplier) {
        this.storageAccuracySupplier = storageAccuracySupplier;
    }

    @Override
    public Histogram apply(Histogram input) {
        Histogram result = input;
        if (HistogramRecompressor.hasDuplicateCentroids(input)) {
            result = HistogramRecompressor.compactCentroids(input);
            this.histogramsCompacted.get().inc();
        }
        if (result.getBins().size() > 2 * this.storageAccuracySupplier.get()) {
            AgentDigest digest = new AgentDigest(this.storageAccuracySupplier.get(), 0L);
            HistogramUtils.mergeHistogram((TDigest)digest, result);
            digest.compress();
            result = digest.toHistogram(input.getDuration());
            this.histogramsRecompressed.get().inc();
        }
        return result;
    }

    @VisibleForTesting
    static boolean hasDuplicateCentroids(Histogram histogram) {
        HashSet<Double> uniqueBins = new HashSet<Double>();
        for (Double bin : histogram.getBins()) {
            if (uniqueBins.add(bin)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static Histogram compactCentroids(Histogram histogram) {
        List bins = histogram.getBins();
        List counts = histogram.getCounts();
        int numCentroids = Math.min(bins.size(), counts.size());
        ArrayList<Double> newBins = new ArrayList<Double>();
        ArrayList<Integer> newCounts = new ArrayList<Integer>();
        Double accumulatedValue = null;
        int accumulatedCount = 0;
        for (int i = 0; i < numCentroids; ++i) {
            double value = (Double)bins.get(i);
            int count = (Integer)counts.get(i);
            if (accumulatedValue == null) {
                accumulatedValue = value;
            } else if (value != accumulatedValue) {
                newBins.add(accumulatedValue);
                newCounts.add(accumulatedCount);
                accumulatedValue = value;
                accumulatedCount = 0;
            }
            accumulatedCount += count;
        }
        if (accumulatedValue != null) {
            newCounts.add(accumulatedCount);
            newBins.add(accumulatedValue);
        }
        return Histogram.newBuilder().setDuration(histogram.getDuration()).setBins(newBins).setCounts(newCounts).setType(HistogramType.TDIGEST).build();
    }
}

