/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RecyclableRateLimiter;
import com.wavefront.agent.data.EntityProperties;
import com.wavefront.agent.data.EntityPropertiesFactory;
import com.wavefront.common.EvictingRingBuffer;
import com.wavefront.common.Managed;
import com.wavefront.common.SynchronizedEvictingRingBuffer;
import com.wavefront.data.ReportableEntityType;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class TrafficShapingRateLimitAdjuster
extends TimerTask
implements Managed {
    private static final Logger log = Logger.getLogger(TrafficShapingRateLimitAdjuster.class.getCanonicalName());
    private static final int MIN_RATE_LIMIT = 10;
    private static final double TOLERANCE_PERCENT = 5.0;
    private final Map<String, EntityPropertiesFactory> entityPropsFactoryMap;
    private final double headroom;
    private final Map<ReportableEntityType, EvictingRingBuffer<Long>> perEntityStats = new EnumMap<ReportableEntityType, EvictingRingBuffer<Long>>(ReportableEntityType.class);
    private final Timer timer;
    private final int windowSeconds;

    public TrafficShapingRateLimitAdjuster(Map<String, EntityPropertiesFactory> entityPropsFactoryMap, int windowSeconds, double headroom) {
        this.windowSeconds = windowSeconds;
        Preconditions.checkArgument((headroom >= 1.0 ? 1 : 0) != 0, (Object)"headroom can't be less than 1!");
        Preconditions.checkArgument((windowSeconds > 0 ? 1 : 0) != 0, (Object)"windowSeconds needs to be > 0!");
        this.entityPropsFactoryMap = entityPropsFactoryMap;
        this.headroom = headroom;
        this.timer = new Timer("traffic-shaping-adjuster-timer");
    }

    @Override
    public void run() {
        for (ReportableEntityType type : ReportableEntityType.values()) {
            for (EntityPropertiesFactory propsFactory : this.entityPropsFactoryMap.values()) {
                EntityProperties props = propsFactory.get(type);
                long rate = props.getTotalReceivedRate();
                EvictingRingBuffer stats = this.perEntityStats.computeIfAbsent(type, x -> new SynchronizedEvictingRingBuffer(this.windowSeconds));
                if (rate <= 0L && stats.size() <= 0) continue;
                stats.add((Object)rate);
                if (stats.size() < 60) continue;
                RecyclableRateLimiter rateLimiter = props.getRateLimiter();
                this.adjustRateLimiter(type, (EvictingRingBuffer<Long>)stats, rateLimiter);
            }
        }
    }

    @Override
    public void start() {
        this.timer.scheduleAtFixedRate((TimerTask)this, 1000L, 1000L);
    }

    @Override
    public void stop() {
        this.timer.cancel();
    }

    @VisibleForTesting
    void adjustRateLimiter(ReportableEntityType type, EvictingRingBuffer<Long> sample, RecyclableRateLimiter rateLimiter) {
        List samples = sample.toList();
        double suggestedLimit = 10.0 + (double)samples.stream().mapToLong(i -> i).sum() / (double)samples.size() * this.headroom;
        double currentRate = rateLimiter.getRate();
        if (Math.abs(currentRate - suggestedLimit) > currentRate * 5.0 / 100.0) {
            log.fine("Setting rate limit for " + type.toString() + " to " + suggestedLimit);
            rateLimiter.setRate(suggestedLimit);
        }
    }
}

