/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.wavefront.agent.handlers.AbstractReportableEntityHandler;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.SenderTask;
import com.wavefront.api.agent.ValidationConfiguration;
import com.wavefront.common.Clock;
import com.wavefront.data.AnnotationUtils;
import com.wavefront.data.Validation;
import com.wavefront.ingester.SpanSerializer;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.Span;
import wavefront.report.SpanLogs;

public class SpanHandlerImpl
extends AbstractReportableEntityHandler<Span, String> {
    private final ValidationConfiguration validationConfig;
    private final Logger validItemsLogger;
    private final Function<String, Integer> dropSpansDelayedMinutes;
    private final Histogram receivedTagCount;
    private final Counter policySampledSpanCounter;
    private final Supplier<ReportableEntityHandler<SpanLogs, String>> spanLogsHandler;

    SpanHandlerImpl(HandlerKey handlerKey, int blockedItemsPerBatch, Map<String, Collection<SenderTask<String>>> senderTaskMap, @Nonnull ValidationConfiguration validationConfig, @Nullable BiConsumer<String, Long> receivedRateSink, @Nullable Logger blockedItemLogger, @Nullable Logger validItemsLogger, @Nonnull Function<String, Integer> dropSpansDelayedMinutes, @Nonnull Supplier<ReportableEntityHandler<SpanLogs, String>> spanLogsHandler) {
        super(handlerKey, blockedItemsPerBatch, new SpanSerializer(), senderTaskMap, true, receivedRateSink, blockedItemLogger);
        super.initializeCounters();
        this.validationConfig = validationConfig;
        this.validItemsLogger = validItemsLogger;
        this.dropSpansDelayedMinutes = dropSpansDelayedMinutes;
        this.receivedTagCount = Metrics.newHistogram((MetricName)new MetricName(handlerKey.toString() + ".received", "", "tagCount"), (boolean)false);
        this.spanLogsHandler = spanLogsHandler;
        this.policySampledSpanCounter = Metrics.newCounter((MetricName)new MetricName(handlerKey.toString(), "", "sampler.policy.saved"));
    }

    @Override
    protected void reportInternal(Span span) {
        this.receivedTagCount.update(span.getAnnotations().size());
        Integer maxSpanDelay = this.dropSpansDelayedMinutes.apply("central");
        if (maxSpanDelay != null && span.getStartMillis() + span.getDuration() < Clock.now() - TimeUnit.MINUTES.toMillis(maxSpanDelay.intValue())) {
            this.reject(span, "span is older than acceptable delay of " + maxSpanDelay + " minutes");
            return;
        }
        if (span.getStartMillis() > Clock.now() + TimeUnit.HOURS.toMillis(24L)) {
            this.reject(span, "Span outside of reasonable timeframe");
            return;
        }
        if (span.getName().contains("*")) {
            span.setName(span.getName().replace('*', '-'));
        }
        Validation.validateSpan((Span)span, (ValidationConfiguration)this.validationConfig, this.spanLogsHandler.get()::report);
        if (span.getAnnotations() != null && AnnotationUtils.getValue((List)span.getAnnotations(), (String)"_sampledByPolicy") != null) {
            this.policySampledSpanCounter.inc();
        }
        String strSpan = (String)this.serializer.apply(span);
        this.getTask("central").add(strSpan);
        this.getReceivedCounter().inc();
        if (this.isMulticastingActive && span.getAnnotations() != null && AnnotationUtils.getValue((List)span.getAnnotations(), (String)"multicastingTenantName") != null) {
            String[] multicastingTenantNames = AnnotationUtils.getValue((List)span.getAnnotations(), (String)"multicastingTenantName").trim().split(",");
            SpanHandlerImpl.removeSpanAnnotation(span.getAnnotations(), "multicastingTenantName");
            for (String multicastingTenantName : multicastingTenantNames) {
                if (this.getTask(multicastingTenantName) == null || (maxSpanDelay = this.dropSpansDelayedMinutes.apply(multicastingTenantName)) != null && span.getStartMillis() + span.getDuration() < Clock.now() - TimeUnit.MINUTES.toMillis(maxSpanDelay.intValue())) continue;
                this.getTask(multicastingTenantName).add((String)this.serializer.apply(span));
            }
        }
        if (this.validItemsLogger != null) {
            this.validItemsLogger.info(strSpan);
        }
    }

    private static void removeSpanAnnotation(List<Annotation> annotations, String key) {
        Annotation toRemove = null;
        for (Annotation annotation : annotations) {
            if (!annotation.getKey().equals(key)) continue;
            toRemove = annotation;
            break;
        }
        annotations.remove(toRemove);
    }
}

