/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.wavefront.agent.data.EntityPropertiesFactory;
import com.wavefront.agent.handlers.EventHandlerImpl;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportLogHandlerImpl;
import com.wavefront.agent.handlers.ReportPointHandlerImpl;
import com.wavefront.agent.handlers.ReportSourceTagHandlerImpl;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.handlers.SenderTaskFactory;
import com.wavefront.agent.handlers.SpanHandlerImpl;
import com.wavefront.agent.handlers.SpanLogsHandlerImpl;
import com.wavefront.api.agent.ValidationConfiguration;
import com.wavefront.common.Utils;
import com.wavefront.common.logger.SamplingLogger;
import com.wavefront.data.ReportableEntityType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.math.NumberUtils;
import wavefront.report.Histogram;

public class ReportableEntityHandlerFactoryImpl
implements ReportableEntityHandlerFactory {
    private static final Logger logger = Logger.getLogger("sampling");
    public static final Logger VALID_POINTS_LOGGER = new SamplingLogger(ReportableEntityType.POINT, Logger.getLogger("RawValidPoints"), ReportableEntityHandlerFactoryImpl.getSystemPropertyAsDouble("wavefront.proxy.logpoints.sample-rate"), "true".equalsIgnoreCase(System.getProperty("wavefront.proxy.logpoints")), logger::info);
    public static final Logger VALID_HISTOGRAMS_LOGGER = new SamplingLogger(ReportableEntityType.HISTOGRAM, Logger.getLogger("RawValidHistograms"), ReportableEntityHandlerFactoryImpl.getSystemPropertyAsDouble("wavefront.proxy.logpoints.sample-rate"), "true".equalsIgnoreCase(System.getProperty("wavefront.proxy.logpoints")), logger::info);
    private static final Logger VALID_SPANS_LOGGER = new SamplingLogger(ReportableEntityType.TRACE, Logger.getLogger("RawValidSpans"), ReportableEntityHandlerFactoryImpl.getSystemPropertyAsDouble("wavefront.proxy.logspans.sample-rate"), false, logger::info);
    private static final Logger VALID_SPAN_LOGS_LOGGER = new SamplingLogger(ReportableEntityType.TRACE_SPAN_LOGS, Logger.getLogger("RawValidSpanLogs"), ReportableEntityHandlerFactoryImpl.getSystemPropertyAsDouble("wavefront.proxy.logspans.sample-rate"), false, logger::info);
    private static final Logger VALID_EVENTS_LOGGER = new SamplingLogger(ReportableEntityType.EVENT, Logger.getLogger("RawValidEvents"), ReportableEntityHandlerFactoryImpl.getSystemPropertyAsDouble("wavefront.proxy.logevents.sample-rate"), false, logger::info);
    private static final Logger VALID_LOGS_LOGGER = new SamplingLogger(ReportableEntityType.LOGS, Logger.getLogger("RawValidLogs"), ReportableEntityHandlerFactoryImpl.getSystemPropertyAsDouble("wavefront.proxy.loglogs.sample-rate"), false, logger::info);
    protected final Map<String, Map<ReportableEntityType, ReportableEntityHandler<?, ?>>> handlers = new ConcurrentHashMap();
    private final SenderTaskFactory senderTaskFactory;
    private final int blockedItemsPerBatch;
    private final ValidationConfiguration validationConfig;
    private final Logger blockedPointsLogger;
    private final Logger blockedHistogramsLogger;
    private final Logger blockedSpansLogger;
    private final Logger blockedLogsLogger;
    private final Function<Histogram, Histogram> histogramRecompressor;
    private final Map<String, EntityPropertiesFactory> entityPropsFactoryMap;

    public ReportableEntityHandlerFactoryImpl(SenderTaskFactory senderTaskFactory, int blockedItemsPerBatch, @Nonnull ValidationConfiguration validationConfig, Logger blockedPointsLogger, Logger blockedHistogramsLogger, Logger blockedSpansLogger, @Nullable Function<Histogram, Histogram> histogramRecompressor, Map<String, EntityPropertiesFactory> entityPropsFactoryMap, Logger blockedLogsLogger) {
        this.senderTaskFactory = senderTaskFactory;
        this.blockedItemsPerBatch = blockedItemsPerBatch;
        this.validationConfig = validationConfig;
        this.blockedPointsLogger = blockedPointsLogger;
        this.blockedHistogramsLogger = blockedHistogramsLogger;
        this.blockedSpansLogger = blockedSpansLogger;
        this.histogramRecompressor = histogramRecompressor;
        this.blockedLogsLogger = blockedLogsLogger;
        this.entityPropsFactoryMap = entityPropsFactoryMap;
    }

    @Override
    public <T, U> ReportableEntityHandler<T, U> getHandler(HandlerKey handlerKey) {
        BiConsumer<String, Long> receivedRateSink = (tenantName, rate) -> this.entityPropsFactoryMap.get(tenantName).get(handlerKey.getEntityType()).reportReceivedRate(handlerKey.getHandle(), (long)rate);
        return this.handlers.computeIfAbsent(handlerKey.getHandle(), h -> new ConcurrentHashMap()).computeIfAbsent(handlerKey.getEntityType(), k -> {
            switch (handlerKey.getEntityType()) {
                case POINT: {
                    return new ReportPointHandlerImpl(handlerKey, this.blockedItemsPerBatch, this.senderTaskFactory.createSenderTasks(handlerKey), this.validationConfig, true, receivedRateSink, this.blockedPointsLogger, VALID_POINTS_LOGGER, null);
                }
                case HISTOGRAM: {
                    return new ReportPointHandlerImpl(handlerKey, this.blockedItemsPerBatch, this.senderTaskFactory.createSenderTasks(handlerKey), this.validationConfig, true, receivedRateSink, this.blockedHistogramsLogger, VALID_HISTOGRAMS_LOGGER, this.histogramRecompressor);
                }
                case SOURCE_TAG: {
                    return new ReportSourceTagHandlerImpl(handlerKey, this.blockedItemsPerBatch, this.senderTaskFactory.createSenderTasks(handlerKey), receivedRateSink, this.blockedPointsLogger);
                }
                case TRACE: {
                    return new SpanHandlerImpl(handlerKey, this.blockedItemsPerBatch, this.senderTaskFactory.createSenderTasks(handlerKey), this.validationConfig, receivedRateSink, this.blockedSpansLogger, VALID_SPANS_LOGGER, tenantName -> this.entityPropsFactoryMap.get(tenantName).getGlobalProperties().getDropSpansDelayedMinutes(), Utils.lazySupplier(() -> this.getHandler(HandlerKey.of(ReportableEntityType.TRACE_SPAN_LOGS, handlerKey.getHandle()))));
                }
                case TRACE_SPAN_LOGS: {
                    return new SpanLogsHandlerImpl(handlerKey, this.blockedItemsPerBatch, this.senderTaskFactory.createSenderTasks(handlerKey), receivedRateSink, this.blockedSpansLogger, VALID_SPAN_LOGS_LOGGER);
                }
                case EVENT: {
                    return new EventHandlerImpl(handlerKey, this.blockedItemsPerBatch, this.senderTaskFactory.createSenderTasks(handlerKey), receivedRateSink, this.blockedPointsLogger, VALID_EVENTS_LOGGER);
                }
                case LOGS: {
                    return new ReportLogHandlerImpl(handlerKey, this.blockedItemsPerBatch, this.senderTaskFactory.createSenderTasks(handlerKey), this.validationConfig, true, receivedRateSink, this.blockedLogsLogger, VALID_LOGS_LOGGER);
                }
            }
            throw new IllegalArgumentException("Unexpected entity type " + handlerKey.getEntityType().name() + " for " + handlerKey.getHandle());
        });
    }

    @Override
    public void shutdown(@Nonnull String handle) {
        if (this.handlers.containsKey(handle)) {
            this.handlers.get(handle).values().forEach(ReportableEntityHandler::shutdown);
        }
    }

    private static double getSystemPropertyAsDouble(String propertyName) {
        String sampleRateProperty = propertyName == null ? null : System.getProperty(propertyName);
        return NumberUtils.isNumber((String)sampleRateProperty) ? Double.parseDouble(sampleRateProperty) : 1.0;
    }
}

