/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.agent.handlers.AbstractReportableEntityHandler;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.SenderTask;
import com.wavefront.data.Validation;
import com.wavefront.dto.SourceTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import wavefront.report.ReportSourceTag;
import wavefront.report.SourceOperationType;

class ReportSourceTagHandlerImpl
extends AbstractReportableEntityHandler<ReportSourceTag, SourceTag> {
    private static final Function<ReportSourceTag, String> SOURCE_TAG_SERIALIZER = value -> new SourceTag(value).toString();

    public ReportSourceTagHandlerImpl(HandlerKey handlerKey, int blockedItemsPerBatch, @Nullable Map<String, Collection<SenderTask<SourceTag>>> senderTaskMap, @Nullable BiConsumer<String, Long> receivedRateSink, Logger blockedItemLogger) {
        super(handlerKey, blockedItemsPerBatch, SOURCE_TAG_SERIALIZER, senderTaskMap, true, receivedRateSink, blockedItemLogger);
        super.initializeCounters();
    }

    @Override
    protected void reportInternal(ReportSourceTag sourceTag) {
        if (!ReportSourceTagHandlerImpl.annotationsAreValid(sourceTag)) {
            throw new IllegalArgumentException("WF-401: SourceTag annotation key has illegal characters.");
        }
        this.getTask(sourceTag).add(new SourceTag(sourceTag));
        this.getReceivedCounter().inc();
    }

    @VisibleForTesting
    static boolean annotationsAreValid(ReportSourceTag sourceTag) {
        if (sourceTag.getOperation() == SourceOperationType.SOURCE_DESCRIPTION) {
            return true;
        }
        return sourceTag.getAnnotations().stream().allMatch(Validation::charactersAreValid);
    }

    private SenderTask<SourceTag> getTask(ReportSourceTag sourceTag) {
        ArrayList senderTasks = new ArrayList((Collection)this.senderTaskMap.get("central"));
        return (SenderTask)senderTasks.get(Math.abs(sourceTag.getSource().hashCode()) % senderTasks.size());
    }
}

