/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.wavefront.agent.LogsUtil;
import com.wavefront.agent.formatter.DataFormat;
import com.wavefront.agent.handlers.AbstractReportableEntityHandler;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.SenderTask;
import com.wavefront.api.agent.ValidationConfiguration;
import com.wavefront.common.Clock;
import com.wavefront.data.Validation;
import com.wavefront.dto.Log;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.BurstRateTrackingCounter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.ReportLog;

public class ReportLogHandlerImpl
extends AbstractReportableEntityHandler<ReportLog, Log> {
    private static final Function<ReportLog, String> LOG_SERIALIZER = value -> new Log(value).toString();
    private final Logger validItemsLogger;
    final ValidationConfiguration validationConfig;
    private final MetricsRegistry registry;
    private DataFormat format;

    public ReportLogHandlerImpl(HandlerKey handlerKey, int blockedItemsPerBatch, @Nullable Map<String, Collection<SenderTask<Log>>> senderTaskMap, @Nonnull ValidationConfiguration validationConfig, boolean setupMetrics, @Nullable BiConsumer<String, Long> receivedRateSink, @Nullable Logger blockedLogsLogger, @Nullable Logger validLogsLogger) {
        super(handlerKey, blockedItemsPerBatch, LOG_SERIALIZER, senderTaskMap, true, receivedRateSink, blockedLogsLogger);
        this.validItemsLogger = validLogsLogger;
        this.validationConfig = validationConfig;
        this.registry = setupMetrics ? Metrics.defaultRegistry() : LOCAL_REGISTRY;
    }

    @Override
    protected void initializeCounters() {
        this.blockedCounter = LogsUtil.getOrCreateLogsCounterFromRegistry(this.registry, this.format, this.metricPrefix, "blocked");
        this.rejectedCounter = LogsUtil.getOrCreateLogsCounterFromRegistry(this.registry, this.format, this.metricPrefix, "rejected");
        if (this.format == DataFormat.LOGS_JSON_CLOUDWATCH) {
            MetricName receivedMetricName = new MetricName(this.metricPrefix + "." + this.format.name().toLowerCase(), "", "received");
            this.registry.newCounter(receivedMetricName).inc();
            final BurstRateTrackingCounter receivedStats = new BurstRateTrackingCounter(receivedMetricName, this.registry, 1000);
            this.registry.newGauge(new MetricName(this.metricPrefix + "." + this.format.name().toLowerCase(), "", "received.max-burst-rate"), (Gauge)new Gauge<Double>(){

                public Double value() {
                    return receivedStats.getMaxBurstRateAndClear();
                }
            });
        }
    }

    @Override
    protected void reportInternal(ReportLog log) {
        this.initializeCounters();
        LogsUtil.getOrCreateLogsHistogramFromRegistry(this.registry, this.format, this.metricPrefix + ".received", "tagCount").update(log.getAnnotations().size());
        LogsUtil.getOrCreateLogsHistogramFromRegistry(this.registry, this.format, this.metricPrefix + ".received", "messageLength").update(log.getMessage().length());
        Histogram receivedTagLength = LogsUtil.getOrCreateLogsHistogramFromRegistry(this.registry, this.format, this.metricPrefix + ".received", "tagLength");
        for (Annotation a : log.getAnnotations()) {
            receivedTagLength.update(a.getValue().length());
        }
        Validation.validateLog((ReportLog)log, (ValidationConfiguration)this.validationConfig);
        LogsUtil.getOrCreateLogsHistogramFromRegistry(this.registry, this.format, this.metricPrefix + ".received", "lag").update(Clock.now() - log.getTimestamp());
        Log logObj = new Log(log);
        LogsUtil.getOrCreateLogsCounterFromRegistry(this.registry, this.format, this.metricPrefix + ".received", "bytes").inc((long)logObj.getDataSize());
        this.getTask("central").add(logObj);
        this.getReceivedCounter().inc();
        this.attemptedCounter.inc();
        if (this.validItemsLogger != null && this.validItemsLogger.isLoggable(Level.FINEST)) {
            this.validItemsLogger.info(LOG_SERIALIZER.apply(log));
        }
    }

    @Override
    public void setLogFormat(DataFormat format) {
        this.format = format;
    }
}

